/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.SqlValidator;
import org.seasar.doma.internal.apt.meta.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.internal.util.StringUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractSqlFileQueryMetaFactory<M extends AbstractSqlFileQueryMeta>
extends AbstractQueryMetaFactory<M> {
    protected AbstractSqlFileQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    protected void doSqlFiles(M queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        if (!Options.getSqlValidation(this.env)) {
            return;
        }
        String filePath = SqlFileUtil.buildPath(daoMeta.getDaoElement().getQualifiedName().toString(), ((AbstractQueryMeta)queryMeta).getName());
        File file = this.getFile(queryMeta, method, filePath);
        File[] siblingfiles = this.getSiblingFiles(queryMeta, method, file);
        String dirPath = SqlFileUtil.buildPath(daoMeta.getDaoElement().getQualifiedName().toString());
        String methodName = ((AbstractQueryMeta)queryMeta).getName();
        for (File siblingfile : siblingfiles) {
            if (!SqlFileUtil.isSqlFile(siblingfile, methodName)) continue;
            String fileName = siblingfile.getName();
            String sqlFilePath = dirPath + "/" + fileName;
            String sql = this.getSql(method, siblingfile, sqlFilePath);
            if (sql.isEmpty() || StringUtil.isWhitespace(sql)) {
                throw new AptException((MessageResource)Message.DOMA4020, this.env, (Element)method, sqlFilePath);
            }
            SqlNode sqlNode = this.createSqlNode(queryMeta, method, daoMeta, sqlFilePath, sql);
            SqlValidator validator = this.createSqlValidator(method, ((AbstractQueryMeta)queryMeta).getBindableParameterTypeMap(), sqlFilePath);
            validator.validate(sqlNode);
            ((AbstractQueryMeta)queryMeta).addFileName(fileName);
        }
    }

    protected File getFile(M queryMeta, ExecutableElement method, String filePath) {
        File file;
        FileObject fileObject = this.getFileObject(filePath, method);
        URI uri = fileObject.toUri();
        if (!uri.isAbsolute()) {
            uri = new File(".").toURI().resolve(uri);
        }
        if (!(file = new File(uri)).exists()) {
            throw new AptException((MessageResource)Message.DOMA4019, this.env, (Element)method, filePath, file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new AptException((MessageResource)Message.DOMA4021, this.env, (Element)method, filePath, file.getAbsolutePath());
        }
        return file;
    }

    protected File[] getSiblingFiles(M queryMeta, ExecutableElement method, File file) {
        File dir = this.getDir(file);
        File[] files = dir.listFiles();
        if (files == null) {
            throw new AptException((MessageResource)Message.DOMA4144, this.env, (Element)method, dir.getAbsolutePath());
        }
        return files;
    }

    protected File getDir(File sqlFile) {
        File dir = sqlFile.getParentFile();
        if (dir == null) {
            AssertionUtil.assertUnreachable();
        }
        return dir;
    }

    protected FileObject getFileObject(String path, ExecutableElement method) {
        Filer filer = this.env.getFiler();
        try {
            return filer.getResource(StandardLocation.CLASS_OUTPUT, "", path);
        }
        catch (IOException e) {
            throw new AptException((MessageResource)Message.DOMA4143, this.env, (Element)method, e, path, e);
        }
    }

    protected String getSql(ExecutableElement method, File file, String filePath) {
        try {
            return IOUtil.readAsString(file);
        }
        catch (WrapException e) {
            Throwable cause = e.getCause();
            throw new AptException((MessageResource)Message.DOMA4068, this.env, (Element)method, cause, filePath, cause);
        }
    }

    protected SqlNode createSqlNode(M queryMeta, ExecutableElement method, DaoMeta daoMeta, String path, String sql) {
        try {
            SqlParser sqlParser = new SqlParser(sql);
            return sqlParser.parse();
        }
        catch (JdbcException e) {
            throw new AptException((MessageResource)Message.DOMA4069, this.env, (Element)method, e, path, e);
        }
    }

    protected SqlValidator createSqlValidator(ExecutableElement method, Map<String, TypeMirror> parameterTypeMap, String sqlFilePath) {
        return new SqlValidator(this.env, method, parameterTypeMap, sqlFilePath);
    }
}

