/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.jdbc.type.AbstractJdbcType;

public class IntegerAdaptiveBooleanType
extends AbstractJdbcType<Boolean> {
    public IntegerAdaptiveBooleanType() {
        super(4);
    }

    @Override
    protected Boolean doGetValue(ResultSet resultSet, int index) throws SQLException {
        int value = resultSet.getInt(index);
        return this.formIntToBoolean(value);
    }

    @Override
    protected void doSetValue(PreparedStatement preparedStatement, int index, Boolean value) throws SQLException {
        int i = this.fromBooleanToInt(value);
        preparedStatement.setInt(index, i);
    }

    @Override
    protected Boolean doGetValue(CallableStatement callableStatement, int index) throws SQLException {
        int value = callableStatement.getInt(index);
        return this.formIntToBoolean(value);
    }

    @Override
    protected String doConvertToLogFormat(Boolean value) {
        int i = this.fromBooleanToInt(value);
        return String.valueOf(i);
    }

    protected int fromBooleanToInt(Boolean value) {
        return value != false ? 1 : 0;
    }

    protected Boolean formIntToBoolean(int value) {
        return value == 1;
    }
}

