/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import java.util.List;
import org.seasar.doma.internal.jdbc.query.ModifyQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AutoModifyQuery<E>
implements ModifyQuery {
    protected static final String[] EMPTY_STRINGS = new String[0];
    protected String[] includedPropertyNames = EMPTY_STRINGS;
    protected String[] excludedPropertyNames = EMPTY_STRINGS;
    protected final EntityType<E> entityType;
    protected Method method;
    protected Config config;
    protected E entity;
    protected String callerClassName;
    protected String callerMethodName;
    protected PreparedSql sql;
    protected List<EntityPropertyType<E, ?>> targetPropertyTypes;
    protected List<EntityPropertyType<E, ?>> idPropertyTypes;
    protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;
    protected boolean optimisticLockCheckRequired;
    protected boolean autoGeneratedKeysSupported;
    protected boolean executable;
    protected SqlExecutionSkipCause sqlExecutionSkipCause = SqlExecutionSkipCause.STATE_UNCHANGED;
    protected int queryTimeout;

    protected AutoModifyQuery(EntityType<E> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    protected void prepareIdAndVersionPropertyTypes() {
        this.idPropertyTypes = this.entityType.getIdPropertyTypes();
        this.versionPropertyType = this.entityType.getVersionPropertyType();
    }

    protected void validateIdExistent() {
        if (this.idPropertyTypes.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2022, this.entityType.getName());
        }
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected boolean isTargetPropertyName(String name) {
        if (this.includedPropertyNames.length > 0) {
            for (String includedName : this.includedPropertyNames) {
                if (!includedName.equals(name)) continue;
                for (String excludedName : this.excludedPropertyNames) {
                    if (!excludedName.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludedPropertyNames.length > 0) {
            for (String excludedName : this.excludedPropertyNames) {
                if (!excludedName.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setEntity(E entity) {
        this.entity = entity;
    }

    public E getEntity() {
        return this.entity;
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setIncludedPropertyNames(String ... includedPropertyNames) {
        this.includedPropertyNames = includedPropertyNames;
    }

    public void setExcludedPropertyNames(String ... excludedPropertyNames) {
        this.excludedPropertyNames = excludedPropertyNames;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.sqlExecutionSkipCause;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return this.autoGeneratedKeysSupported;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

