/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.seasar.doma.wrapper.BigIntegerWrapper;

public class BigIntegerWrapperTest
extends TestCase {
    public void testSetBigIntegerAsNumber() {
        BigInteger greaterThanLongMaxValue = new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE).toBigInteger();
        BigIntegerWrapper wrapper = new BigIntegerWrapper();
        wrapper.set((Number)greaterThanLongMaxValue);
        BigIntegerWrapperTest.assertEquals((Object)greaterThanLongMaxValue, (Object)wrapper.get());
    }

    public void testSetBigDecimal() {
        BigDecimal greaterThanLongMaxValue = new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE);
        BigIntegerWrapper wrapper = new BigIntegerWrapper();
        wrapper.set((Number)greaterThanLongMaxValue);
        BigIntegerWrapperTest.assertEquals((Object)greaterThanLongMaxValue.toBigInteger(), (Object)wrapper.get());
    }

    public void testIncrement() {
        BigIntegerWrapper wrapper = new BigIntegerWrapper(new BigInteger("10"));
        wrapper.increment();
        BigIntegerWrapperTest.assertEquals((Object)new BigInteger("11"), (Object)wrapper.get());
    }

    public void testDecrement() {
        BigIntegerWrapper wrapper = new BigIntegerWrapper(new BigInteger("10"));
        wrapper.decrement();
        BigIntegerWrapperTest.assertEquals((Object)new BigInteger("9"), (Object)wrapper.get());
    }
}

