/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.seasar.doma.wrapper.BigDecimalWrapper;

public class BigDecimalWrapperTest
extends TestCase {
    public void testSetBigDecimalAsNumber() {
        BigDecimal greaterThanLongMaxValue = new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE);
        BigDecimalWrapper wrapper = new BigDecimalWrapper();
        wrapper.set((Number)greaterThanLongMaxValue);
        BigDecimalWrapperTest.assertEquals((Object)greaterThanLongMaxValue, (Object)wrapper.get());
    }

    public void testSetBigInteger() {
        BigInteger greaterThanLongMaxValue = new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE).toBigInteger();
        BigDecimalWrapper wrapper = new BigDecimalWrapper();
        wrapper.set((Number)greaterThanLongMaxValue);
        BigDecimalWrapperTest.assertEquals((Object)new BigDecimal(greaterThanLongMaxValue), (Object)wrapper.get());
    }

    public void testIncrement() {
        BigDecimalWrapper wrapper = new BigDecimalWrapper(new BigDecimal(10));
        wrapper.increment();
        BigDecimalWrapperTest.assertEquals((Object)new BigDecimal(11), (Object)wrapper.get());
    }

    public void testDecrement() {
        BigDecimalWrapper wrapper = new BigDecimalWrapper(new BigDecimal(10));
        wrapper.decrement();
        BigDecimalWrapperTest.assertEquals((Object)new BigDecimal(9), (Object)wrapper.get());
    }
}

