/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class StandardDialectTest
extends TestCase {
    public void testApplyQuote() {
        StandardDialect dialect = new StandardDialect();
        StandardDialectTest.assertEquals((String)"\"aaa\"", (String)dialect.applyQuote("aaa"));
    }

    public void testRemoveQuote() {
        StandardDialect dialect = new StandardDialect();
        StandardDialectTest.assertEquals((String)"aaa", (String)dialect.removeQuote("\"aaa\""));
        StandardDialectTest.assertEquals((String)"bbb", (String)dialect.removeQuote("bbb"));
    }

    public void testExpressionFunctions_prefix() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"a$$a$%a$_%", (String)functions.prefix("a$a%a_"));
    }

    public void testExpressionFunctions_prefix_escape() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"a!!a!%a!_%", (String)functions.prefix("a!a%a_", '!'));
    }

    public void testExpressionFunctions_prefix_escapeWithBackslash() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"a\\\\a\\%a\\_%", (String)functions.prefix("a\\a%a_", '\\'));
    }

    public void testExpressionFunctions_suffix() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"%a$$a$%a$_", (String)functions.suffix("a$a%a_"));
    }

    public void testExpressionFunctions_suffix_escape() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"%a!!a!%a!_", (String)functions.suffix("a!a%a_", '!'));
    }

    public void testExpressionFunctions_suffix_escapeWithBackslash() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"%a\\\\a\\%a\\_", (String)functions.suffix("a\\a%a_", '\\'));
    }

    public void testExpressionFunctions_infix() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"%a$$a$%a$_%", (String)functions.infix("a$a%a_"));
    }

    public void testExpressionFunctions_infix_escape() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"%a!!a!%a!_%", (String)functions.infix("a!a%a_", '!'));
    }

    public void testExpressionFunctions_infix_escapeWithBackslash() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertEquals((String)"%a\\\\a\\%a\\_%", (String)functions.infix("a\\a%a_", '\\'));
    }

    public void testExpressionFunctions_roundDonwTimePart_forUtilDate() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 0, 23, 12, 34, 56);
        Date date = new Date(calendar.getTimeInMillis());
        StandardDialectTest.assertEquals((Object)java.sql.Date.valueOf("2009-01-23"), (Object)functions.roundDownTimePart(date));
    }

    public void testExpressionFunctions_roundDonwTimePart_forDate() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 0, 23, 12, 34, 56);
        java.sql.Date date = new java.sql.Date(calendar.getTimeInMillis());
        StandardDialectTest.assertEquals((Object)java.sql.Date.valueOf("2009-01-23"), (Object)functions.roundDownTimePart(date));
    }

    public void testExpressionFunctions_roundDonwTimePart_forTimestamp() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Timestamp timestamp = Timestamp.valueOf("2009-01-23 12:34:56.123456789");
        StandardDialectTest.assertEquals((Object)Timestamp.valueOf("2009-01-23 00:00:00.000000000"), (Object)functions.roundDownTimePart(timestamp));
    }

    public void testExpressionFunctions_roundUpTimePart_forUtilDate() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 0, 23, 12, 34, 56);
        Date date = new Date(calendar.getTimeInMillis());
        StandardDialectTest.assertEquals((long)java.sql.Date.valueOf("2009-01-24").getTime(), (long)functions.roundUpTimePart(date).getTime());
    }

    public void testExpressionFunctions_roundUpTimePart_forDate() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 0, 23, 12, 34, 56);
        java.sql.Date date = new java.sql.Date(calendar.getTimeInMillis());
        StandardDialectTest.assertEquals((long)java.sql.Date.valueOf("2009-01-24").getTime(), (long)functions.roundUpTimePart(date).getTime());
    }

    public void testExpressionFunctions_roundUpTimePart_forDate_endOfMonth() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 2, 31, 0, 0, 0);
        java.sql.Date date = new java.sql.Date(calendar.getTimeInMillis());
        StandardDialectTest.assertEquals((long)java.sql.Date.valueOf("2009-04-01").getTime(), (long)functions.roundUpTimePart(date).getTime());
    }

    public void testExpressionFunctions_roundUpTimePart_forDate_endOfYear() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 11, 31, 0, 0, 0);
        java.sql.Date date = new java.sql.Date(calendar.getTimeInMillis());
        StandardDialectTest.assertEquals((long)java.sql.Date.valueOf("2010-01-01").getTime(), (long)functions.roundUpTimePart(date).getTime());
    }

    public void testExpressionFunctions_roundUpTimePart_forTimestamp() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Timestamp timestamp = Timestamp.valueOf("2009-01-23 12:34:56.123456789");
        StandardDialectTest.assertEquals((Object)Timestamp.valueOf("2009-01-24 00:00:00.000000000"), (Object)functions.roundUpTimePart(timestamp));
    }

    public void testExpressionFunctions_roundUpTimePart_forTimestamp_endOfMonth() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Timestamp timestamp = Timestamp.valueOf("2009-03-31 00:00:00.000000000");
        StandardDialectTest.assertEquals((Object)Timestamp.valueOf("2009-04-01 00:00:00.000000000"), (Object)functions.roundUpTimePart(timestamp));
    }

    public void testExpressionFunctions_roundUpTimePart_forTimestamp_endOfYear() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Timestamp timestamp = Timestamp.valueOf("2009-12-31 00:00:00.000000000");
        StandardDialectTest.assertEquals((Object)Timestamp.valueOf("2010-01-01 00:00:00.000000000"), (Object)functions.roundUpTimePart(timestamp));
    }

    public void testExpressionFunctions_isEmpty() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertTrue((boolean)functions.isEmpty(null));
        StandardDialectTest.assertTrue((boolean)functions.isEmpty((CharSequence)""));
        StandardDialectTest.assertFalse((boolean)functions.isEmpty((CharSequence)" "));
        StandardDialectTest.assertFalse((boolean)functions.isEmpty((CharSequence)" \t\n\r "));
        StandardDialectTest.assertFalse((boolean)functions.isEmpty((CharSequence)"a"));
        StandardDialectTest.assertFalse((boolean)functions.isEmpty((CharSequence)" a "));
    }

    public void testExpressionFunctions_isNotEmpty() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertFalse((boolean)functions.isNotEmpty(null));
        StandardDialectTest.assertFalse((boolean)functions.isNotEmpty((CharSequence)""));
        StandardDialectTest.assertTrue((boolean)functions.isNotEmpty((CharSequence)" "));
        StandardDialectTest.assertTrue((boolean)functions.isNotEmpty((CharSequence)" \t\n\r "));
        StandardDialectTest.assertTrue((boolean)functions.isNotEmpty((CharSequence)"a"));
        StandardDialectTest.assertTrue((boolean)functions.isNotEmpty((CharSequence)" a "));
    }

    public void testExpressionFunctions_isBlank() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertTrue((boolean)functions.isBlank(null));
        StandardDialectTest.assertTrue((boolean)functions.isBlank((CharSequence)""));
        StandardDialectTest.assertTrue((boolean)functions.isBlank((CharSequence)" "));
        StandardDialectTest.assertTrue((boolean)functions.isBlank((CharSequence)" \t\n\r "));
        StandardDialectTest.assertFalse((boolean)functions.isBlank((CharSequence)"a"));
        StandardDialectTest.assertFalse((boolean)functions.isBlank((CharSequence)" a "));
    }

    public void testExpressionFunctions_isNotBlank() throws Exception {
        StandardDialect dialect = new StandardDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        StandardDialectTest.assertFalse((boolean)functions.isNotBlank(null));
        StandardDialectTest.assertFalse((boolean)functions.isNotBlank((CharSequence)""));
        StandardDialectTest.assertFalse((boolean)functions.isNotBlank((CharSequence)" "));
        StandardDialectTest.assertFalse((boolean)functions.isNotBlank((CharSequence)" \t\n\r "));
        StandardDialectTest.assertTrue((boolean)functions.isNotBlank((CharSequence)"a"));
        StandardDialectTest.assertTrue((boolean)functions.isNotBlank((CharSequence)" a "));
    }

    public void testTransformSelectSqlNode_forUpdate() throws Exception {
        StandardDialect dialect = new StandardDialect();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = parser.parse();
        SelectOptions options = SelectOptions.get().forUpdate();
        try {
            dialect.transformSelectSqlNode(sqlNode, options);
            StandardDialectTest.fail();
        }
        catch (JdbcException ex) {
            System.out.println(ex.getMessage());
            StandardDialectTest.assertEquals((String)"DOMA2023", (String)ex.getMessageResource().getCode());
        }
    }

    public void testTransformSelectSqlNode_forUpdateWait() throws Exception {
        StandardDialect dialect = new StandardDialect();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = parser.parse();
        SelectOptions options = SelectOptions.get().forUpdateWait(1);
        try {
            dialect.transformSelectSqlNode(sqlNode, options);
            StandardDialectTest.fail();
        }
        catch (JdbcException ex) {
            System.out.println(ex.getMessage());
            StandardDialectTest.assertEquals((String)"DOMA2079", (String)ex.getMessageResource().getCode());
        }
    }

    public void testTransformSelectSqlNode_forUpdateNowait() throws Exception {
        StandardDialect dialect = new StandardDialect();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = parser.parse();
        SelectOptions options = SelectOptions.get().forUpdateNowait();
        try {
            dialect.transformSelectSqlNode(sqlNode, options);
            StandardDialectTest.fail();
        }
        catch (JdbcException ex) {
            System.out.println(ex.getMessage());
            StandardDialectTest.assertEquals((String)"DOMA2080", (String)ex.getMessageResource().getCode());
        }
    }

    public void testTransformSelectSqlNode_forUpdate_alias() throws Exception {
        StandardDialectStab dialect = new StandardDialectStab();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = parser.parse();
        SelectOptions options = SelectOptions.get().forUpdate(new String[]{"emp"});
        try {
            dialect.transformSelectSqlNode(sqlNode, options);
            StandardDialectTest.fail();
        }
        catch (JdbcException ex) {
            System.out.println(ex.getMessage());
            StandardDialectTest.assertEquals((String)"DOMA2024", (String)ex.getMessageResource().getCode());
        }
    }

    public void testTransformSelectSqlNode_forUpdateWait_alias() throws Exception {
        StandardDialectStab dialect = new StandardDialectStab();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = parser.parse();
        SelectOptions options = SelectOptions.get().forUpdateWait(1, new String[]{"emp"});
        try {
            dialect.transformSelectSqlNode(sqlNode, options);
            StandardDialectTest.fail();
        }
        catch (JdbcException ex) {
            System.out.println(ex.getMessage());
            StandardDialectTest.assertEquals((String)"DOMA2081", (String)ex.getMessageResource().getCode());
        }
    }

    public void testTransformSelectSqlNode_forUpdateNowait_alias() throws Exception {
        StandardDialectStab dialect = new StandardDialectStab();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = parser.parse();
        SelectOptions options = SelectOptions.get().forUpdateNowait(new String[]{"emp"});
        try {
            dialect.transformSelectSqlNode(sqlNode, options);
            StandardDialectTest.fail();
        }
        catch (JdbcException ex) {
            System.out.println(ex.getMessage());
            StandardDialectTest.assertEquals((String)"DOMA2082", (String)ex.getMessageResource().getCode());
        }
    }

    public static class StandardDialectStab
    extends StandardDialect {
        public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
            return !withTargets;
        }
    }
}

