/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import example.domain.PhoneNumber;
import example.entity.Emp;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.builder.SelectBuilder;

public class SelectBuilderTest
extends TestCase {
    public void testRmoveLast() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("aaa").sql("bbb");
        builder.removeLast();
        SelectBuilderTest.assertEquals((String)"aaa", (String)builder.getSql().getRawSql());
    }

    public void testSingleResult_Entity() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select");
        builder.sql("id").sql(",");
        builder.sql("name").sql(",");
        builder.sql("salary");
        builder.sql("from Emp");
        builder.sql("where");
        builder.sql("name like ").param(String.class, (Object)"S%");
        builder.sql("and");
        builder.sql("age > ").param(Integer.TYPE, (Object)20);
        Emp emp = (Emp)builder.getSingleResult(Emp.class);
        SelectBuilderTest.assertNull((Object)emp);
    }

    public void testSingleResult_Map() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select");
        builder.sql("id").sql(",");
        builder.sql("name").sql(",");
        builder.sql("salary");
        builder.sql("from Emp");
        builder.sql("where");
        builder.sql("name like ").param(String.class, (Object)"S%");
        builder.sql("and");
        builder.sql("age > ").param(Integer.TYPE, (Object)20);
        Map emp = builder.getSingleResult(MapKeyNamingType.CAMEL_CASE);
        SelectBuilderTest.assertNull((Object)emp);
    }

    public void testSingleResult_Domain() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select ccc from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        PhoneNumber phoneNumber = (PhoneNumber)builder.getSingleResult(PhoneNumber.class);
        SelectBuilderTest.assertNull((Object)phoneNumber);
    }

    public void testSingleResult_Basic() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select ccc from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        String result = (String)builder.getSingleResult(String.class);
        SelectBuilderTest.assertNull((Object)result);
    }

    public void testSingleResult_DomaIllegalArgumentException() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select");
        builder.sql("aaa").sql(",");
        builder.sql("bbb");
        builder.sql("from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        try {
            builder.getSingleResult(Object.class);
            SelectBuilderTest.fail();
        }
        catch (DomaIllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    public void testGetResultList_Entity() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select * from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        List list = builder.getResultList(Emp.class);
        SelectBuilderTest.assertNotNull((Object)list);
    }

    public void testGetResultList_Map() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select * from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        List list = builder.getResultList(MapKeyNamingType.CAMEL_CASE);
        SelectBuilderTest.assertNotNull((Object)list);
    }

    public void testGetResultList_Domain() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select ccc from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        List list = builder.getResultList(PhoneNumber.class);
        SelectBuilderTest.assertNotNull((Object)list);
    }

    public void testGetResultList_Basic() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select ccc from Emp");
        builder.sql("where");
        builder.sql("aaa = ").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        List list = builder.getResultList(String.class);
        SelectBuilderTest.assertNotNull((Object)list);
    }

    public void testIterate_Entity() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select * from Emp");
        builder.sql("where");
        builder.sql("aaa =").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        builder.iterate(Emp.class, (IterationCallback)new IterationCallback<Void, Emp>(){

            public Void iterate(Emp target, IterationContext context) {
                return null;
            }
        });
    }

    public void testIterate_Map() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select * from Emp");
        builder.sql("where");
        builder.sql("aaa =").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        builder.iterate(MapKeyNamingType.CAMEL_CASE, (IterationCallback)new IterationCallback<Void, Map<String, Object>>(){

            public Void iterate(Map<String, Object> target, IterationContext context) {
                return null;
            }
        });
    }

    public void testIterate_Domain() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select ccc from Emp");
        builder.sql("where");
        builder.sql("aaa =").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        builder.iterate(PhoneNumber.class, (IterationCallback)new IterationCallback<Void, PhoneNumber>(){

            public Void iterate(PhoneNumber target, IterationContext context) {
                return null;
            }
        });
    }

    public void testIterate_Basic() throws Exception {
        SelectBuilder builder = SelectBuilder.newInstance((Config)new MockConfig());
        builder.sql("select ccc from Emp");
        builder.sql("where");
        builder.sql("aaa =").param(String.class, (Object)"aaa");
        builder.sql("and");
        builder.sql("bbb = ").param(Integer.TYPE, (Object)100);
        builder.iterate(String.class, (IterationCallback)new IterationCallback<Void, String>(){

            public Void iterate(String target, IterationContext context) {
                return null;
            }
        });
    }
}

