/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import example.domain.PhoneNumber;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.util.ResourceUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;

public class SqlParserTest
extends TestCase {
    private final MockConfig config = new MockConfig();

    public void testBindVariable() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where ename = ? and sal = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where ename = 'hoge' and sal = 10000", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)2, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)new BigDecimal(10000), (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testBindVariable_domain() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("phone", new Value(PhoneNumber.class, (Object)new PhoneNumber("01-2345-6789")));
        String testSql = "select * from aaa where phone = /*phone*/'111'";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where phone = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where phone = '01-2345-6789'", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"01-2345-6789", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
    }

    public void testBindVariable_in() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(List.class, Arrays.asList("hoge", "foo")));
        String testSql = "select * from aaa where ename in /*name*/('aaa', 'bbb')";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where ename in (?, ?)", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where ename in ('hoge', 'foo')", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)2, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)"foo", (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testBindVariable_endsWithBindVariableComment() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        String testSql = "select * from aaa where ename = /*name*/";
        SqlParser parser = new SqlParser(testSql);
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2110, (Object)expected.getMessageResource());
        }
    }

    public void testBindVariable_emptyName() throws Exception {
        String testSql = "select * from aaa where ename = /*   */'aaa'";
        SqlParser parser = new SqlParser(testSql);
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2120, (Object)expected.getMessageResource());
        }
    }

    public void testBindVariable_stringLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/'bbb'";
        SqlParser parser = new SqlParser(testSql);
        SqlNode node = parser.parse();
        SqlParserTest.assertNotNull((Object)node);
    }

    public void testBindVariable_intLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/10";
        SqlParser parser = new SqlParser(testSql);
        SqlNode node = parser.parse();
        SqlParserTest.assertNotNull((Object)node);
    }

    public void testBindVariable_floatLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/.0";
        SqlParser parser = new SqlParser(testSql);
        SqlNode node = parser.parse();
        SqlParserTest.assertNotNull((Object)node);
    }

    public void testBindVariable_booleanTrueLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/true";
        SqlParser parser = new SqlParser(testSql);
        SqlNode node = parser.parse();
        SqlParserTest.assertNotNull((Object)node);
    }

    public void testBindVariable_booleanFalseLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/false";
        SqlParser parser = new SqlParser(testSql);
        SqlNode node = parser.parse();
        SqlParserTest.assertNotNull((Object)node);
    }

    public void testBindVariable_nullLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/null";
        SqlParser parser = new SqlParser(testSql);
        SqlNode node = parser.parse();
        SqlParserTest.assertNotNull((Object)node);
    }

    public void testBindVariable_illegalLiteral() throws Exception {
        String testSql = "select * from aaa where ename = /*name*/bbb";
        SqlParser parser = new SqlParser(testSql);
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2142, (Object)expected.getMessageResource());
        }
    }

    public void testBindVariable_enum() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(MyEnum.class, (Object)MyEnum.BBB));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where ename = ? and sal = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where ename = 'BBB' and sal = 10000", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)2, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)((Object)MyEnum.BBB), (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)new BigDecimal(10000), (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testEmbeddedVariable() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        evaluator.add("orderBy", new Value(String.class, (Object)"order by name asc, salary"));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000 /*#orderBy*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where ename = ? and sal = ? order by name asc, salary", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where ename = 'hoge' and sal = 10000 order by name asc, salary", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)2, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)new BigDecimal(10000), (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testEmbeddedVariable_inside() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        evaluator.add("table", new Value(String.class, (Object)"aaa"));
        String testSql = "select * from /*# table */ where ename = /*name*/'aaa' and sal = /*salary*/-2000";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where ename = ? and sal = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where ename = 'hoge' and sal = 10000", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)2, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)new BigDecimal(10000), (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testEmbeddedVariable_emptyName() throws Exception {
        String testSql = "select * from aaa where ename = /*#   */'aaa'";
        SqlParser parser = new SqlParser(testSql);
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2121, (Object)expected.getMessageResource());
        }
    }

    public void testIf() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        String testSql = "select * from aaa where /*%if name != null*/bbb = /*name*/'ccc' /*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where bbb = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where bbb = 'hoge'", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
    }

    public void testIf_fromClause() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("type", new Value(String.class, (Object)"a"));
        String testSql = "select * from /*%if type == \"a\"*/aaa--else bbb/*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getFormattedSql());
    }

    public void testIf_selectClause() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("type", new Value(String.class, (Object)"a"));
        String testSql = "select /*%if type == \"a\"*/aaa --else bbb /*%end*/from ccc";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select aaa from ccc", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select aaa from ccc", (String)sql.getFormattedSql());
    }

    public void testIf_removeWhere() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, null));
        String testSql = "select * from aaa where /*%if name != null*/bbb = /*name*/'ccc' /*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)0, (int)sql.getParameters().size());
    }

    public void testIf_removeAnd() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, null));
        String testSql = "select * from aaa where \n/*%if name != null*/bbb = /*name*/'ccc' \n--else\n --comment\nand ddd is null\n /*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where \n\n --comment\n ddd is null", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where \n\n --comment\n ddd is null", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)0, (int)sql.getParameters().size());
    }

    public void testIf_nest() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        String testSql = "select * from aaa where /*%if name != null*/bbb = /*name*/'ccc' /*%if name == \"hoge\"*/and ddd = eee/*%end*//*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where bbb = ? and ddd = eee", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where bbb = 'hoge' and ddd = eee", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
    }

    public void testIf_nestContinuously() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("name2", new Value(String.class, null));
        String testSql = "select * from aaa where /*%if name != null*//*%if name2 == \"hoge\"*/ ddd = eee/*%end*//*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)0, (int)sql.getParameters().size());
    }

    public void testElseifLine() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)""));
        String testSql = "select * from aaa where /*%if name == null*/bbb is null--elseif name ==\"\"--bbb = /*name*/'ccc'/*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where bbb = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where bbb = ''", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
    }

    public void testElseifBlock() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)""));
        String testSql = "select * from aaa where /*%if name == null*/bbb is null\n/*%elseif name ==\"\"*/\nbbb = /*name*/'ccc'/*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where \nbbb = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where \nbbb = ''", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
    }

    public void testElseLine() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        String testSql = "select * from aaa where /*%if name == null*/bbb is null--elseif name == \"\"----else bbb = /*name*/'ccc'/*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where  bbb = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where  bbb = 'hoge'", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
    }

    public void testElseBlock() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        String testSql = "select * from aaa where /*%if name == null*/bbb is null\n/*%elseif name == \"\"*/\n/*%else*/ bbb = /*name*/'ccc'/*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where  bbb = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where  bbb = 'hoge'", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)1, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
    }

    public void testUnion() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        String testSql = "select * from aaa where /*%if false*//*%end*/union all select * from bbb";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa union all select * from bbb", (String)sql.getRawSql());
    }

    public void testSelect() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("count", new Value(Integer.class, (Object)5));
        String testSql = "select aaa.deptname, count(*) from aaa join bbb on aaa.id = bbb.id where aaa.name = /*name*/'ccc' group by aaa.deptname having count(*) > /*count*/10 order by aaa.name for update bbb";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select aaa.deptname, count(*) from aaa join bbb on aaa.id = bbb.id where aaa.name = ? group by aaa.deptname having count(*) > ? order by aaa.name for update bbb", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select aaa.deptname, count(*) from aaa join bbb on aaa.id = bbb.id where aaa.name = 'hoge' group by aaa.deptname having count(*) > 5 order by aaa.name for update bbb", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)2, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)new Integer(5), (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testUpdate() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("no", new Value(Integer.class, (Object)10));
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("id", new Value(Integer.class, (Object)100));
        String testSql = "update aaa set no = /*no*/1, set name = /*name*/'name' where id = /*id*/1";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"update aaa set no = ?, set name = ? where id = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"update aaa set no = 10, set name = 'hoge' where id = 100", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)3, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
        SqlParserTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)sql.getParameters().get(2)).getWrapper().get());
    }

    public void testFor() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        evaluator.add("names", new Value(List.class, list));
        String testSql = "select * from aaa where /*%for n : names*/name = /*n*/'a' /*%if n_has_next */or /*%end*//*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where name = ? or name = ? or name = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where name = 'aaa' or name = 'bbb' or name = 'ccc'", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)3, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)"bbb", (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
        SqlParserTest.assertEquals((Object)"ccc", (Object)((PreparedSqlParameter)sql.getParameters().get(2)).getWrapper().get());
    }

    public void testFor_removeWhere() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        ArrayList list = new ArrayList();
        evaluator.add("names", new Value(List.class, list));
        String testSql = "select * from aaa where /*%for n : names*/name = /*n*/'a' /*%if n_has_next */or /*%end*//*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)0, (int)sql.getParameters().size());
    }

    public void testFor_removeOr() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        ArrayList list = new ArrayList();
        evaluator.add("names", new Value(List.class, list));
        String testSql = "select * from aaa where /*%for n : names*/name = /*n*/'a' /*%if n_has_next */or /*%end*//*%end*/ or salary > 100";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where   salary > 100", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where   salary > 100", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)0, (int)sql.getParameters().size());
    }

    public void testFor_index() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        evaluator.add("names", new Value(List.class, list));
        String testSql = "select * from aaa where /*%for n : names*/name/*# n_index */ = /*n*/'a' /*%if n_has_next */or /*%end*//*%end*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where name0 = ? or name1 = ? or name2 = ?", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where name0 = 'aaa' or name1 = 'bbb' or name2 = 'ccc'", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)3, (int)sql.getParameters().size());
        SqlParserTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        SqlParserTest.assertEquals((Object)"bbb", (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
        SqlParserTest.assertEquals((Object)"ccc", (Object)((PreparedSqlParameter)sql.getParameters().get(2)).getWrapper().get());
    }

    public void testValidate_ifEnd() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa /*%if true*/");
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2133, (Object)expected.getMessageResource());
        }
    }

    public void testValidate_ifEnd_selectClause() throws Exception {
        SqlParser parser = new SqlParser("select /*%if true*/* from aaa");
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2133, (Object)expected.getMessageResource());
        }
    }

    public void testValidate_ifEnd_subquery() throws Exception {
        SqlParser parser = new SqlParser("select *, (select /*%if true */ from aaa) x from aaa");
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2133, (Object)expected.getMessageResource());
        }
    }

    public void testValidate_forEnd() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa /*%for name : names*/");
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2134, (Object)expected.getMessageResource());
        }
    }

    public void testValidate_unclosedParens() throws Exception {
        SqlParser parser = new SqlParser("select * from (select * from bbb");
        try {
            parser.parse();
            SqlParserTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            SqlParserTest.assertEquals((Object)Message.DOMA2135, (Object)expected.getMessageResource());
        }
    }

    public void testValidate_enclosedParensByIfBlock() throws Exception {
        SqlParser parser = new SqlParser("select * from /*%if true*/(select * from bbb)/*%end*/");
        parser.parse();
    }

    public void testParens_removeAnd() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, null));
        String testSql = "select * from aaa where (\n/*%if name != null*/bbb = /*name*/'ccc'\n/*%else*/\nand ddd is null\n /*%end*/)";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select * from aaa where (\n\n ddd is null\n )", (String)sql.getRawSql());
        SqlParserTest.assertEquals((String)"select * from aaa where (\n\n ddd is null\n )", (String)sql.getFormattedSql());
        SqlParserTest.assertEquals((int)0, (int)sql.getParameters().size());
    }

    public void testEmptyParens() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        SqlParser parser = new SqlParser("select rank()");
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select rank()", (String)sql.getRawSql());
    }

    public void testEmptyParens_whiteSpace() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        SqlParser parser = new SqlParser("select rank(   )");
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        SqlParserTest.assertEquals((String)"select rank(   )", (String)sql.getRawSql());
    }

    public void testManyEol() throws Exception {
        String path = "META-INF/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + "/manyEol.sql";
        String sql = ResourceUtil.getResourceAsString((String)path);
        SqlParser parser = new SqlParser(sql);
        SqlNode sqlNode = parser.parse();
        SqlParserTest.assertNotNull((Object)sqlNode);
    }

    public static enum MyEnum {
        AAA,
        BBB,
        CCC;

    }
}

