/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.SqlFileScriptQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ScriptFileNotFoundException;
import org.seasar.doma.jdbc.dialect.Mssql2008Dialect;

public class SqlFileScriptQueryTest
extends TestCase {
    private final MockConfig config = new MockConfig();

    public void testPrepare() throws Exception {
        SqlFileScriptQuery query = new SqlFileScriptQuery();
        query.setConfig((Config)this.config);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setScriptFilePath("META-INF/org/seasar/doma/internal/jdbc/query/SqlFileScriptQueryTest/testPrepare.script");
        query.setBlockDelimiter("");
        query.prepare();
        SqlFileScriptQueryTest.assertEquals((Object)this.config, (Object)query.getConfig());
        SqlFileScriptQueryTest.assertEquals((String)"aaa", (String)query.getClassName());
        SqlFileScriptQueryTest.assertEquals((String)"bbb", (String)query.getMethodName());
        SqlFileScriptQueryTest.assertEquals((String)"META-INF/org/seasar/doma/internal/jdbc/query/SqlFileScriptQueryTest/testPrepare.script", (String)query.getScriptFilePath());
        SqlFileScriptQueryTest.assertNotNull((Object)query.getScriptFileUrl());
        SqlFileScriptQueryTest.assertNull((Object)query.getBlockDelimiter());
    }

    public void testPrepare_dbmsSpecific() throws Exception {
        this.config.dialect = new Mssql2008Dialect();
        SqlFileScriptQuery query = new SqlFileScriptQuery();
        query.setConfig((Config)this.config);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setScriptFilePath("META-INF/org/seasar/doma/internal/jdbc/query/SqlFileScriptQueryTest/testPrepare_dbmsSpecific.script");
        query.setBlockDelimiter("");
        query.prepare();
        SqlFileScriptQueryTest.assertEquals((Object)this.config, (Object)query.getConfig());
        SqlFileScriptQueryTest.assertEquals((String)"aaa", (String)query.getClassName());
        SqlFileScriptQueryTest.assertEquals((String)"bbb", (String)query.getMethodName());
        SqlFileScriptQueryTest.assertEquals((String)"META-INF/org/seasar/doma/internal/jdbc/query/SqlFileScriptQueryTest/testPrepare_dbmsSpecific-mssql2008.script", (String)query.getScriptFilePath());
        SqlFileScriptQueryTest.assertNotNull((Object)query.getScriptFileUrl());
        SqlFileScriptQueryTest.assertEquals((String)"GO", (String)query.getBlockDelimiter());
    }

    public void testPrepare_ScriptFileNotFoundException() throws Exception {
        SqlFileScriptQuery query = new SqlFileScriptQuery();
        query.setConfig((Config)this.config);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setScriptFilePath("META-INF/ccc.script");
        query.setBlockDelimiter("ddd");
        try {
            query.prepare();
            SqlFileScriptQueryTest.fail();
        }
        catch (ScriptFileNotFoundException expected) {
            System.out.println(expected.getMessage());
        }
    }
}

