/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.InsertCommand;
import org.seasar.doma.internal.jdbc.mock.BindValue;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoInsertQuery;
import org.seasar.doma.internal.jdbc.query.InsertQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class InsertCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute() throws Exception {
        Emp emp = new Emp();
        emp.setId(1);
        emp.setName("hoge");
        emp.setSalary(new BigDecimal(1000));
        emp.setVersion(10);
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        int rows = new InsertCommand((InsertQuery)query).execute();
        query.complete();
        InsertCommandTest.assertEquals((int)1, (int)rows);
        String sql = this.runtimeConfig.dataSource.connection.preparedStatement.sql;
        InsertCommandTest.assertEquals((String)"insert into EMP (ID, NAME, SALARY, VERSION) values (?, ?, ?, ?)", (String)sql);
        List<BindValue> bindValues = this.runtimeConfig.dataSource.connection.preparedStatement.bindValues;
        InsertCommandTest.assertEquals((Object)new Integer(1), (Object)bindValues.get(0).getValue());
        InsertCommandTest.assertEquals((Object)new String("hoge"), (Object)bindValues.get(1).getValue());
        InsertCommandTest.assertEquals((Object)new BigDecimal(1000), (Object)bindValues.get(2).getValue());
        InsertCommandTest.assertEquals((Object)new Integer(10), (Object)bindValues.get(3).getValue());
    }

    public void testExecute_defaultVersion() throws Exception {
        Emp emp = new Emp();
        emp.setId(1);
        emp.setName("hoge");
        emp.setSalary(new BigDecimal(1000));
        emp.setVersion(null);
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        int rows = new InsertCommand((InsertQuery)query).execute();
        query.complete();
        InsertCommandTest.assertEquals((int)1, (int)rows);
        String sql = this.runtimeConfig.dataSource.connection.preparedStatement.sql;
        InsertCommandTest.assertEquals((String)"insert into EMP (ID, NAME, SALARY, VERSION) values (?, ?, ?, ?)", (String)sql);
        List<BindValue> bindValues = this.runtimeConfig.dataSource.connection.preparedStatement.bindValues;
        InsertCommandTest.assertEquals((int)4, (int)bindValues.size());
        InsertCommandTest.assertEquals((Object)new Integer(1), (Object)bindValues.get(0).getValue());
        InsertCommandTest.assertEquals((Object)new String("hoge"), (Object)bindValues.get(1).getValue());
        InsertCommandTest.assertEquals((Object)new BigDecimal(1000), (Object)bindValues.get(2).getValue());
        InsertCommandTest.assertEquals((Object)new Integer(1), (Object)bindValues.get(3).getValue());
    }
}

