/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.FunctionCommand;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoFunctionQuery;
import org.seasar.doma.internal.jdbc.query.FunctionQuery;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameter;
import org.seasar.doma.internal.jdbc.sql.ResultParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Reference;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class FunctionCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute() throws Exception {
        List<Object> outParameters = this.runtimeConfig.dataSource.connection.callableStatement.outParameters;
        outParameters.add(10);
        outParameters.add(null);
        outParameters.add(20);
        outParameters.add(30);
        IntegerWrapper aaa = new IntegerWrapper(Integer.valueOf(40));
        IntegerWrapper bbb = new IntegerWrapper(Integer.valueOf(50));
        IntegerWrapper ccc = new IntegerWrapper(Integer.valueOf(60));
        AutoFunctionQuery query = new AutoFunctionQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setFunctionName("aaa");
        query.setResultParameter((ResultParameter)new BasicResultParameter((Wrapper)new IntegerWrapper(), false));
        query.addParameter((CallableSqlParameter)new BasicInParameter((Wrapper)aaa));
        query.addParameter((CallableSqlParameter)new BasicOutParameter((Wrapper)bbb, new Reference()));
        query.addParameter((CallableSqlParameter)new BasicInOutParameter((Wrapper)ccc, new Reference()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        Integer result = (Integer)new FunctionCommand((FunctionQuery)query).execute();
        query.complete();
        FunctionCommandTest.assertNotNull((Object)result);
        FunctionCommandTest.assertEquals((Object)new Integer(10), (Object)result);
        FunctionCommandTest.assertEquals((Object)new Integer(40), (Object)aaa.get());
        FunctionCommandTest.assertEquals((Object)new Integer(20), (Object)bbb.get());
        FunctionCommandTest.assertEquals((Object)new Integer(30), (Object)ccc.get());
        String sql = this.runtimeConfig.dataSource.connection.callableStatement.sql;
        FunctionCommandTest.assertEquals((String)"{? = call aaa(?, ?, ?)}", (String)sql);
    }
}

