/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.entity;

import javax.annotation.processing.Processor;
import org.seasar.doma.internal.apt.AptTestCase;
import org.seasar.doma.internal.apt.EntityProcessor;
import org.seasar.doma.internal.apt.entity.AbstractEntity;
import org.seasar.doma.internal.apt.entity.AbstractEntityListenerEntity;
import org.seasar.doma.internal.apt.entity.AbstractSequenceIdGeneratorEntity;
import org.seasar.doma.internal.apt.entity.AbstractTableIdGeneratorEntity;
import org.seasar.doma.internal.apt.entity.AnnotationConflictedEntity;
import org.seasar.doma.internal.apt.entity.Child2InheritingEntity;
import org.seasar.doma.internal.apt.entity.Child2NoInheritingEntity;
import org.seasar.doma.internal.apt.entity.Child3InheritingEntity;
import org.seasar.doma.internal.apt.entity.ChildEntity;
import org.seasar.doma.internal.apt.entity.CommonChild;
import org.seasar.doma.internal.apt.entity.Dept;
import org.seasar.doma.internal.apt.entity.DomainPropertyEntity;
import org.seasar.doma.internal.apt.entity.Emp;
import org.seasar.doma.internal.apt.entity.EnumPropertyEntity;
import org.seasar.doma.internal.apt.entity.FinalMissingImmutableEntity;
import org.seasar.doma.internal.apt.entity.GeneratedValueNotNumberEntity;
import org.seasar.doma.internal.apt.entity.GeneratedValueWithCompositeIdEntity;
import org.seasar.doma.internal.apt.entity.GeneratedValueWithoutIdEntity;
import org.seasar.doma.internal.apt.entity.GenericListener1Entity;
import org.seasar.doma.internal.apt.entity.GenericListener2Entity;
import org.seasar.doma.internal.apt.entity.GenericListener3Entity;
import org.seasar.doma.internal.apt.entity.GenericListener4Entity;
import org.seasar.doma.internal.apt.entity.GenericListener5Entity;
import org.seasar.doma.internal.apt.entity.GenericListener6Entity;
import org.seasar.doma.internal.apt.entity.GenericListener8Entity;
import org.seasar.doma.internal.apt.entity.IllegalIdPropertyEntity;
import org.seasar.doma.internal.apt.entity.IllegalMutableChildEntity;
import org.seasar.doma.internal.apt.entity.IllegalOriginalStatesImmutableEntity;
import org.seasar.doma.internal.apt.entity.IllegalVersionPropertyEntity;
import org.seasar.doma.internal.apt.entity.ImmutableChildEntity;
import org.seasar.doma.internal.apt.entity.ImmutableEntity;
import org.seasar.doma.internal.apt.entity.ListenerArgumentTypeIllegalEntity;
import org.seasar.doma.internal.apt.entity.NamingType1Entity;
import org.seasar.doma.internal.apt.entity.NamingType2Entity;
import org.seasar.doma.internal.apt.entity.NamingType3Entity;
import org.seasar.doma.internal.apt.entity.NoDefaultConstructorEntityListenerEntity;
import org.seasar.doma.internal.apt.entity.NoDefaultConstructorSequenceIdGeneratorEntity;
import org.seasar.doma.internal.apt.entity.NoDefaultConstructorTableIdGeneratorEntity;
import org.seasar.doma.internal.apt.entity.NotTopLevelEntity;
import org.seasar.doma.internal.apt.entity.OriginalStatesChildEntity;
import org.seasar.doma.internal.apt.entity.PackagePrivateEntity;
import org.seasar.doma.internal.apt.entity.PrimitivePropertyEntity;
import org.seasar.doma.internal.apt.entity.PrivateOriginalStatesEntity;
import org.seasar.doma.internal.apt.entity.PrivatePropertyEntity;
import org.seasar.doma.internal.apt.entity.PropertyNameReservedEntity;
import org.seasar.doma.internal.apt.entity.RawtypePropertyEntity;
import org.seasar.doma.internal.apt.entity.SequenceGeneratorWithoutGeneratedValueEntity;
import org.seasar.doma.internal.apt.entity.TableGeneratorWithoutGeneratedValueEntity;
import org.seasar.doma.internal.apt.entity.TransientPropertyEntity;
import org.seasar.doma.internal.apt.entity.UnsupportedPropertyEntity;
import org.seasar.doma.internal.apt.entity.VersionDuplicatedEntity;
import org.seasar.doma.internal.apt.entity.VersionNotNumberEntity;
import org.seasar.doma.internal.apt.entity.WildcardPropertyEntity;
import org.seasar.doma.message.Message;

public class EntityProcessorTest
extends AptTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addSourcePath(new String[]{"src/test/java"});
        this.addOption(new String[]{"-Atest=true", "-Adomain.converters=org.seasar.doma.internal.apt.entity.DomainConvertersProvider"});
    }

    public void testEmp() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(Emp.class);
        this.compile();
        this.assertGeneratedSource(Emp.class);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testPrivatePropertyEntity() throws Exception {
        Class<PrivatePropertyEntity> target = PrivatePropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testPrivateOriginalStatesEntity() throws Exception {
        Class<PrivateOriginalStatesEntity> target = PrivateOriginalStatesEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testVersionDuplicated() throws Exception {
        Class<VersionDuplicatedEntity> target = VersionDuplicatedEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4024);
    }

    public void testNotTopLevel() throws Exception {
        Class<NotTopLevelEntity> target = NotTopLevelEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4018);
    }

    public void testUnsupportedProperty() throws Exception {
        Class<UnsupportedPropertyEntity> target = UnsupportedPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4096);
    }

    public void testPrimitiveProperty() throws Exception {
        Class<PrimitivePropertyEntity> target = PrimitivePropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testExtends() throws Exception {
        Class<ChildEntity> target = ChildEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testExtendsListenerInherited() throws Exception {
        Class<Child2InheritingEntity> target = Child2InheritingEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testExtendsListenerNoInherited() throws Exception {
        Class<Child2NoInheritingEntity> target = Child2NoInheritingEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testExtendsListenerIllegalInherited() throws Exception {
        Class<Child3InheritingEntity> target = Child3InheritingEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4230);
    }

    public void testExtendsWithOriginalStates() throws Exception {
        Class<OriginalStatesChildEntity> target = OriginalStatesChildEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testPropertyNameReserved() throws Exception {
        Class<PropertyNameReservedEntity> target = PropertyNameReservedEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4025);
    }

    public void testTransientProperty() throws Exception {
        Class<TransientPropertyEntity> target = TransientPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testVersionNotNumber() throws Exception {
        Class<VersionNotNumberEntity> target = VersionNotNumberEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4093);
    }

    public void testListenerArgumentTypeIllegal() throws Exception {
        Class<ListenerArgumentTypeIllegalEntity> target = ListenerArgumentTypeIllegalEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4038);
    }

    public void testAnnotationConflicted() throws Exception {
        Class<AnnotationConflictedEntity> target = AnnotationConflictedEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4086);
    }

    public void testDomainProperty() throws Exception {
        Class<DomainPropertyEntity> target = DomainPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testEnumProperty() throws Exception {
        Class<EnumPropertyEntity> target = EnumPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testAbstract() throws Exception {
        Class<AbstractEntity> target = AbstractEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testCommonListener() throws Exception {
        Class<CommonChild> target = CommonChild.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testPackagePrivate() throws Exception {
        Class<PackagePrivateEntity> target = PackagePrivateEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testAbstractEntityListener() throws Exception {
        Class<AbstractEntityListenerEntity> target = AbstractEntityListenerEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4166);
    }

    public void testNoDefaultConstructorEntityListener() throws Exception {
        Class<NoDefaultConstructorEntityListenerEntity> target = NoDefaultConstructorEntityListenerEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4167);
    }

    public void testAbstractSequenceIdGenerator() throws Exception {
        Class<AbstractSequenceIdGeneratorEntity> target = AbstractSequenceIdGeneratorEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4170);
    }

    public void testNoDefaultConstructorSequenceIdGenerator() throws Exception {
        Class<NoDefaultConstructorSequenceIdGeneratorEntity> target = NoDefaultConstructorSequenceIdGeneratorEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4171);
    }

    public void testAbstractTableIdGenerator() throws Exception {
        Class<AbstractTableIdGeneratorEntity> target = AbstractTableIdGeneratorEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4168);
    }

    public void testNoDefaultConstructorTableIdGenerator() throws Exception {
        Class<NoDefaultConstructorTableIdGeneratorEntity> target = NoDefaultConstructorTableIdGeneratorEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4169);
    }

    public void testGeneratedValueNotNumber() throws Exception {
        Class<GeneratedValueNotNumberEntity> target = GeneratedValueNotNumberEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4095);
    }

    public void testGeneratedValueWithoutId() throws Exception {
        Class<GeneratedValueWithoutIdEntity> target = GeneratedValueWithoutIdEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4033);
    }

    public void testGeneratedValueWithCompositeId() throws Exception {
        Class<GeneratedValueWithCompositeIdEntity> target = GeneratedValueWithCompositeIdEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4036);
    }

    public void testSequenceGeneratorWithoutGeneratedValue() throws Exception {
        Class<SequenceGeneratorWithoutGeneratedValueEntity> target = SequenceGeneratorWithoutGeneratedValueEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4030);
    }

    public void testTableGeneratorWithoutGeneratedValue() throws Exception {
        Class<TableGeneratorWithoutGeneratedValueEntity> target = TableGeneratorWithoutGeneratedValueEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4031);
    }

    public void testDept() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(Dept.class);
        this.compile();
        this.assertGeneratedSource(Dept.class);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testIllegalIdProperty() throws Exception {
        Class<IllegalIdPropertyEntity> target = IllegalIdPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4095);
    }

    public void testIllegalVersionProperty() throws Exception {
        Class<IllegalVersionPropertyEntity> target = IllegalVersionPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4093);
    }

    public void testRawtypeProperty() throws Exception {
        Class<RawtypePropertyEntity> target = RawtypePropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4204);
    }

    public void testWildcardProperty() throws Exception {
        Class<WildcardPropertyEntity> target = WildcardPropertyEntity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4205);
    }

    public void testImmutableEntity() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(ImmutableEntity.class);
        this.compile();
        this.assertGeneratedSource(ImmutableEntity.class);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testIllegalOriginalStatesImmutableEntity() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(IllegalOriginalStatesImmutableEntity.class);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4224);
    }

    public void testFinalMissingImmutableEntity() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(FinalMissingImmutableEntity.class);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4225);
    }

    public void testImmutableChildEntity() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(ImmutableChildEntity.class);
        this.compile();
        this.assertGeneratedSource(ImmutableChildEntity.class);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testIllegalMutableChildEntity() throws Exception {
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(IllegalMutableChildEntity.class);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4226);
    }

    public void testNamingType1() throws Exception {
        Class<NamingType1Entity> target = NamingType1Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testNamingType2() throws Exception {
        Class<NamingType2Entity> target = NamingType2Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testNamingType3() throws Exception {
        Class<NamingType3Entity> target = NamingType3Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testGenericListener1() throws Exception {
        Class<GenericListener1Entity> target = GenericListener1Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testGenericListener2() throws Exception {
        Class<GenericListener2Entity> target = GenericListener2Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4227);
    }

    public void testGenericListener3() throws Exception {
        Class<GenericListener3Entity> target = GenericListener3Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testGenericListener4() throws Exception {
        Class<GenericListener4Entity> target = GenericListener4Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4229);
    }

    public void testGenericListener5() throws Exception {
        Class<GenericListener5Entity> target = GenericListener5Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4166);
    }

    public void testGenericListener6() throws Exception {
        Class<GenericListener6Entity> target = GenericListener6Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        EntityProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testGenericListener8() throws Exception {
        Class<GenericListener8Entity> target = GenericListener8Entity.class;
        EntityProcessor processor = new EntityProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        EntityProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4228);
    }
}

