/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.AnyType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Reference;

public class ReferenceType
extends AbstractDataType {
    protected TypeMirror referentTypeMirror;
    protected DataType referentType;

    public ReferenceType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public DataType getReferentType() {
        return this.referentType;
    }

    public TypeMirror getReferentTypeMirror() {
        return this.referentTypeMirror;
    }

    public boolean isRaw() {
        return this.referentTypeMirror == null;
    }

    public boolean isWildcardType() {
        return this.referentTypeMirror != null && this.referentTypeMirror.getKind() == TypeKind.WILDCARD;
    }

    public static ReferenceType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        DeclaredType referenceDeclaredType = ReferenceType.getReferenceDeclaredType(type, env);
        if (referenceDeclaredType == null) {
            return null;
        }
        ReferenceType referenceType = new ReferenceType(type, env);
        List<? extends TypeMirror> typeArguments = referenceDeclaredType.getTypeArguments();
        if (typeArguments.size() == 1) {
            referenceType.referentTypeMirror = typeArguments.get(0);
            referenceType.referentType = DomainType.newInstance(referenceType.referentTypeMirror, env);
            if (referenceType.referentType == null) {
                referenceType.referentType = BasicType.newInstance(referenceType.referentTypeMirror, env);
                if (referenceType.referentType == null) {
                    referenceType.referentType = AnyType.newInstance(referenceType.referentTypeMirror, env);
                }
            }
        }
        return referenceType;
    }

    protected static DeclaredType getReferenceDeclaredType(TypeMirror type, ProcessingEnvironment env) {
        if (TypeMirrorUtil.isSameType(type, Reference.class, env)) {
            return TypeMirrorUtil.toDeclaredType(type, env);
        }
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            if (TypeMirrorUtil.isSameType(typeMirror, Reference.class, env)) {
                return TypeMirrorUtil.toDeclaredType(typeMirror, env);
            }
            ReferenceType.getReferenceDeclaredType(typeMirror, env);
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitReferenceType(this, p);
    }
}

