/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Delegate;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DelegateQueryMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.mirror.DelegateMirror;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DelegateQueryMetaFactory
extends AbstractQueryMetaFactory<DelegateQueryMeta> {
    public DelegateQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        DelegateQueryMeta queryMeta = this.createDelegateQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doDelegate(queryMeta, method, daoMeta);
        return queryMeta;
    }

    protected DelegateQueryMeta createDelegateQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        DelegateMirror delegateMirror = DelegateMirror.newInstance(method, this.env);
        if (delegateMirror == null) {
            return null;
        }
        DelegateQueryMeta queryMeta = new DelegateQueryMeta(method);
        queryMeta.setDelegateMirror(delegateMirror);
        queryMeta.setQueryKind(QueryKind.DELEGATE);
        return queryMeta;
    }

    protected TypeMirror getTargetType(Delegate delegate) {
        try {
            delegate.to();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        throw new AptIllegalStateException("unreachable.");
    }

    @Override
    protected void doParameters(DelegateQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterType(parameterMeta.getName(), parameterMeta.getType());
        }
    }

    @Override
    protected void doReturnType(DelegateQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta(method);
        queryMeta.setReturnMeta(resultMeta);
    }

    protected void doDelegate(DelegateQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        TypeMirror delegateTypeMirror = queryMeta.getDelegateMirror().getToValue();
        if (delegateTypeMirror == null) {
            throw new AptIllegalStateException(method.toString());
        }
        TypeElement delegateTypeElement = TypeMirrorUtil.toTypeElement(delegateTypeMirror, this.env);
        if (delegateTypeElement == null) {
            throw new AptIllegalStateException(method.toString());
        }
        ExecutableElement constructor = this.getSuitableConstructor(delegateTypeElement, daoMeta);
        if (constructor == null) {
            DelegateMirror delegateMirror = queryMeta.getDelegateMirror();
            throw new AptException((MessageResource)Message.DOMA4080, this.env, (Element)method, delegateMirror.getAnnotationMirror(), delegateMirror.getTo(), delegateTypeElement.getQualifiedName());
        }
        if (constructor.getParameters().size() == 2) {
            queryMeta.setDaoAware(true);
        }
        if (!this.hasDelegatableMethod(method, delegateTypeElement)) {
            DelegateMirror delegateMirror = queryMeta.getDelegateMirror();
            throw new AptException((MessageResource)Message.DOMA4081, this.env, (Element)method, delegateMirror.getAnnotationMirror(), delegateMirror.getTo(), delegateTypeElement.getQualifiedName());
        }
    }

    protected ExecutableElement getSuitableConstructor(TypeElement targetElement, DaoMeta daoMeta) {
        ExecutableElement candidate = null;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(targetElement.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (parameters.size() == 2) {
                VariableElement first = parameters.get(0);
                VariableElement second = parameters.get(1);
                if (!this.isConfig(first.asType()) || !TypeMirrorUtil.isAssignable(second.asType(), daoMeta.getDaoType(), this.env)) continue;
                candidate = constructor;
                break;
            }
            if (parameters.size() != 1 || !this.isConfig(parameters.get(0).asType())) continue;
            candidate = constructor;
        }
        return candidate;
    }

    protected boolean hasDelegatableMethod(ExecutableElement srcMethod, TypeElement targetElement) {
        for (ExecutableElement destMethod : ElementFilter.methodsIn(targetElement.getEnclosedElements())) {
            if (!destMethod.getModifiers().contains((Object)Modifier.PUBLIC) || !this.isSameSignature(srcMethod, destMethod)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSameSignature(ExecutableElement srcMethod, ExecutableElement destMethod) {
        if (!((Object)srcMethod.getSimpleName()).equals(destMethod.getSimpleName())) {
            return false;
        }
        if (!TypeMirrorUtil.isSameType(srcMethod.getReturnType(), destMethod.getReturnType(), this.env)) {
            return false;
        }
        List<? extends TypeParameterElement> srcTypeParams = srcMethod.getTypeParameters();
        List<? extends TypeParameterElement> destTypeParams = destMethod.getTypeParameters();
        if (srcTypeParams.size() != destTypeParams.size()) {
            return false;
        }
        Iterator<? extends TypeParameterElement> srcIt = srcTypeParams.iterator();
        Iterator<? extends TypeParameterElement> destIt = destTypeParams.iterator();
        while (srcIt.hasNext() && destIt.hasNext()) {
            if (TypeMirrorUtil.isSameType(srcIt.next().asType(), destIt.next().asType(), this.env)) continue;
            return false;
        }
        List<? extends VariableElement> srcParams = srcMethod.getParameters();
        List<? extends VariableElement> destParams = destMethod.getParameters();
        if (srcParams.size() != destParams.size()) {
            return false;
        }
        Iterator<? extends VariableElement> srcIt2 = srcParams.iterator();
        Iterator<? extends VariableElement> destIt2 = destParams.iterator();
        while (srcIt2.hasNext() && destIt2.hasNext()) {
            if (TypeMirrorUtil.isSameType(srcIt2.next().asType(), destIt2.next().asType(), this.env)) continue;
            return false;
        }
        List<? extends TypeMirror> srcThrownTypes = srcMethod.getThrownTypes();
        List<? extends TypeMirror> destThrownTypes = destMethod.getThrownTypes();
        if (srcThrownTypes.size() != destThrownTypes.size()) {
            return false;
        }
        Iterator<? extends TypeMirror> srcIt3 = srcThrownTypes.iterator();
        Iterator<? extends TypeMirror> destIt3 = destThrownTypes.iterator();
        while (srcIt3.hasNext() && destIt3.hasNext()) {
            if (TypeMirrorUtil.isSameType(srcIt3.next(), destIt3.next(), this.env)) continue;
            return false;
        }
        return true;
    }
}

