/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.seasar.doma.DaoMethod;
import org.seasar.doma.Suppress;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryMetaFactory;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.AnnotateWithMirror;
import org.seasar.doma.internal.apt.mirror.DaoMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DaoMetaFactory
implements TypeElementMetaFactory<DaoMeta> {
    protected final ProcessingEnvironment env;
    protected final List<QueryMetaFactory> queryMetaFactories = new ArrayList<QueryMetaFactory>();

    public DaoMetaFactory(ProcessingEnvironment env, List<QueryMetaFactory> commandMetaFactories) {
        AssertionUtil.assertNotNull((Object)env, commandMetaFactories);
        this.env = env;
        this.queryMetaFactories.addAll(commandMetaFactories);
    }

    @Override
    public DaoMeta createTypeElementMeta(TypeElement interfaceElement) {
        AssertionUtil.assertNotNull(interfaceElement);
        DaoMirror daoMirror = DaoMirror.newInstance(interfaceElement, this.env);
        if (daoMirror == null) {
            throw new AptIllegalStateException("daoMirror");
        }
        DaoMeta daoMeta = new DaoMeta(daoMirror);
        this.doDaoElement(interfaceElement, daoMeta);
        this.doMethodElements(interfaceElement, daoMeta);
        this.validateFiles(interfaceElement, daoMeta);
        return daoMeta;
    }

    protected void doDaoElement(TypeElement interfaceElement, DaoMeta daoMeta) {
        this.validateInterface(interfaceElement, daoMeta);
        String name = interfaceElement.getSimpleName().toString();
        String suffix = Options.getDaoSuffix(this.env);
        if (name.endsWith(suffix)) {
            Notifier.notify(this.env, Diagnostic.Kind.WARNING, (MessageResource)Message.DOMA4026, interfaceElement, suffix);
        }
        daoMeta.setName(name);
        daoMeta.setDaoElement(interfaceElement);
        daoMeta.setDaoType(interfaceElement.asType());
        this.doAnnotateWith(daoMeta);
        this.doParentDao(daoMeta);
        DaoMirror daoMirror = daoMeta.getDaoMirror();
        if (daoMirror.hasUserDefinedConfig()) {
            TypeElement configElement = TypeMirrorUtil.toTypeElement(daoMirror.getConfigValue(), this.env);
            if (configElement == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement.");
            }
            if (configElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new AptException((MessageResource)Message.DOMA4163, this.env, (Element)daoMeta.getDaoElement(), daoMirror.getAnnotationMirror(), daoMirror.getConfig(), configElement.getQualifiedName());
            }
            ExecutableElement constructor = ElementUtil.getNoArgConstructor(configElement, this.env);
            if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new AptException((MessageResource)Message.DOMA4164, this.env, (Element)daoMeta.getDaoElement(), daoMirror.getAnnotationMirror(), daoMirror.getConfig(), configElement.getQualifiedName());
            }
        }
    }

    protected void validateInterface(TypeElement interfaceElement, DaoMeta daoMeta) {
        if (!interfaceElement.getKind().isInterface()) {
            DaoMirror daoMirror = daoMeta.getDaoMirror();
            throw new AptException((MessageResource)Message.DOMA4014, this.env, (Element)interfaceElement, daoMirror.getAnnotationMirror(), new Object[0]);
        }
        if (interfaceElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4017, this.env, (Element)interfaceElement, new Object[0]);
        }
        if (!interfaceElement.getTypeParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4059, this.env, (Element)interfaceElement, new Object[0]);
        }
    }

    protected void doAnnotateWith(DaoMeta daoMeta) {
        AnnotateWithMirror annotateWithMirror = AnnotateWithMirror.newInstance(daoMeta.getDaoElement(), this.env);
        if (annotateWithMirror != null) {
            daoMeta.setAnnotateWithMirror(annotateWithMirror);
        }
    }

    protected void doParentDao(DaoMeta daoMeta) {
        List<? extends TypeMirror> interfaces = daoMeta.getDaoElement().getInterfaces();
        int size = interfaces.size();
        if (size == 0) {
            return;
        }
        if (size > 1) {
            throw new AptException((MessageResource)Message.DOMA4187, this.env, (Element)daoMeta.getDaoElement(), new Object[0]);
        }
        TypeMirror parentMirror = interfaces.get(0);
        TypeElement parentElement = TypeMirrorUtil.toTypeElement(parentMirror, this.env);
        if (parentElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement.");
        }
        DaoMirror daoMirror = DaoMirror.newInstance(parentElement, this.env);
        if (daoMirror == null) {
            throw new AptException((MessageResource)Message.DOMA4188, this.env, (Element)daoMeta.getDaoElement(), parentElement.getQualifiedName());
        }
        ParentDaoMeta parentDaoMeta = new ParentDaoMeta(daoMirror);
        parentDaoMeta.setDaoType(parentMirror);
        parentDaoMeta.setDaoElement(parentElement);
        daoMeta.setParentDaoMeta(parentDaoMeta);
    }

    protected void doMethodElements(TypeElement interfaceElement, DaoMeta daoMeta) {
        for (ExecutableElement methodElement : ElementFilter.methodsIn(interfaceElement.getEnclosedElements())) {
            try {
                this.doMethodElement(methodElement, daoMeta);
            }
            catch (AptException e) {
                Notifier.notify(this.env, e);
                daoMeta.setError(true);
            }
        }
    }

    protected void doMethodElement(ExecutableElement methodElement, DaoMeta daoMeta) {
        this.validateMethod(methodElement, daoMeta);
        QueryMeta queryMeta = this.createQueryMeta(methodElement, daoMeta);
        daoMeta.addQueryMeta(queryMeta);
    }

    protected void validateMethod(ExecutableElement methodElement, DaoMeta daoMeta) {
        TypeElement foundAnnotationTypeElement = null;
        for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
            if (typeElement.getAnnotation(DaoMethod.class) == null) continue;
            if (foundAnnotationTypeElement != null) {
                throw new AptException((MessageResource)Message.DOMA4086, this.env, (Element)methodElement, foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName());
            }
            foundAnnotationTypeElement = typeElement;
        }
    }

    protected QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        for (QueryMetaFactory factory : this.queryMetaFactories) {
            QueryMeta queryMeta = factory.createQueryMeta(method, daoMeta);
            if (queryMeta == null) continue;
            return queryMeta;
        }
        throw new AptException((MessageResource)Message.DOMA4005, this.env, (Element)method, new Object[0]);
    }

    protected void validateFiles(TypeElement interfaceElement, DaoMeta daoMeta) {
        Message message;
        if (daoMeta.isError()) {
            return;
        }
        if (!Options.getSqlValidation(this.env)) {
            return;
        }
        String dirPath = SqlFileUtil.buildPath(interfaceElement.getQualifiedName().toString());
        Set<String> fileNames = this.getFileNames(dirPath);
        for (QueryMeta queryMeta : daoMeta.getQueryMetas()) {
            for (String fileName : queryMeta.getFileNames()) {
                fileNames.remove(fileName);
            }
        }
        Suppress suppress = interfaceElement.getAnnotation(Suppress.class);
        if (!this.isSuppressed(suppress, message = Message.DOMA4220)) {
            for (String fileName : fileNames) {
                Notifier.notify(this.env, Diagnostic.Kind.WARNING, (MessageResource)message, interfaceElement, dirPath + "/" + fileName);
            }
        }
    }

    protected Set<String> getFileNames(String dirPath) {
        File dir = this.getDir(dirPath);
        if (dir == null) {
            return Collections.emptySet();
        }
        String[] fileNames = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".sql") || name.endsWith(".script");
            }
        });
        return new HashSet<String>(Arrays.asList(fileNames));
    }

    protected File getDir(String dirPath) {
        File dir;
        FileObject fileObject = this.getFileObject(dirPath);
        if (fileObject == null) {
            return null;
        }
        URI uri = fileObject.toUri();
        if (!uri.isAbsolute()) {
            uri = new File(".").toURI().resolve(uri);
        }
        if ((dir = new File(uri)).exists() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    protected FileObject getFileObject(String path) {
        Filer filer = this.env.getFiler();
        try {
            return filer.getResource(StandardLocation.CLASS_OUTPUT, "", path);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected boolean isSuppressed(Suppress suppress, Message message) {
        if (suppress != null) {
            for (Message suppressMessage : suppress.messages()) {
                if (suppressMessage != message) continue;
                return true;
            }
        }
        return false;
    }
}

