/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.DomainTypeGenerator;
import org.seasar.doma.internal.apt.meta.EnumDomainMeta;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.BoxedPrimitiveUtil;

public class EnumDomainTypeGenerator
extends DomainTypeGenerator {
    protected final EnumDomainMeta enumDomainMeta;

    public EnumDomainTypeGenerator(ProcessingEnvironment env, TypeElement domainElement, EnumDomainMeta enumDomainMeta) throws IOException {
        super(env, domainElement, enumDomainMeta);
        this.enumDomainMeta = enumDomainMeta;
    }

    @Override
    protected void printNewDomainMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s newDomain(%2$s value) {%n", this.enumDomainMeta.getTypeElement().getQualifiedName(), TypeMirrorUtil.boxIfPrimitive(this.enumDomainMeta.getValueType(), this.env));
        if (this.enumDomainMeta.getWrapperType().getWrappedType().isPrimitive()) {
            this.iprint("    return %1$s.%2$s(%3$s.unbox(value));%n", this.enumDomainMeta.getTypeElement().getQualifiedName(), this.enumDomainMeta.getFactoryMethod(), BoxedPrimitiveUtil.class.getName());
        } else {
            this.iprint("    return %1$s.%2$s(value);%n", this.enumDomainMeta.getTypeElement().getQualifiedName(), this.enumDomainMeta.getFactoryMethod());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    @Override
    protected WrapperGenerator createWrapperGenerator() {
        return new WrapperGenerator();
    }

    protected class WrapperGenerator
    extends DomainTypeGenerator.WrapperGenerator {
        protected WrapperGenerator() {
        }

        @Override
        protected void pirntWrapperDoSetMethod() {
            EnumDomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            EnumDomainTypeGenerator.this.iprint("protected void doSet(%1$s value) {%n", TypeMirrorUtil.boxIfPrimitive(EnumDomainTypeGenerator.this.enumDomainMeta.getValueType(), EnumDomainTypeGenerator.this.env));
            if (EnumDomainTypeGenerator.this.enumDomainMeta.getWrapperType().getWrappedType().isPrimitive()) {
                EnumDomainTypeGenerator.this.iprint("    domain = %1$s.%2$s(%3$s.unbox(value));%n", EnumDomainTypeGenerator.this.enumDomainMeta.getTypeElement().getQualifiedName(), EnumDomainTypeGenerator.this.enumDomainMeta.getFactoryMethod(), BoxedPrimitiveUtil.class.getName());
            } else {
                EnumDomainTypeGenerator.this.iprint("    domain = %1$s.%2$s(value);%n", EnumDomainTypeGenerator.this.enumDomainMeta.getTypeElement().getQualifiedName(), EnumDomainTypeGenerator.this.enumDomainMeta.getFactoryMethod());
            }
            EnumDomainTypeGenerator.this.iprint("}%n", new Object[0]);
            EnumDomainTypeGenerator.this.print("%n", new Object[0]);
        }
    }
}

