/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import org.seasar.doma.internal.jdbc.query.AutoModuleQuery;
import org.seasar.doma.internal.jdbc.query.FunctionQuery;
import org.seasar.doma.internal.jdbc.sql.CallableSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.ResultParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;

public class AutoFunctionQuery<R>
extends AutoModuleQuery
implements FunctionQuery<R> {
    protected String functionName;
    protected ResultParameter<R> resultParameter;

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.functionName, this.resultParameter, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void prepareSql() {
        CallableSqlBuilder builder = new CallableSqlBuilder(this.config, SqlKind.FUNCTION, this.functionName, this.parameters, this.resultParameter);
        this.sql = builder.build();
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setResultParameter(ResultParameter<R> parameter) {
        this.resultParameter = parameter;
    }

    @Override
    public R getResult() {
        return this.resultParameter.getResult();
    }

    @Override
    public String getModuleName() {
        return this.functionName;
    }
}

