/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import org.seasar.doma.Domain;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.wrapper.WrapperException;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeFactory;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;
import org.seasar.doma.wrapper.Wrapper;

public final class Wrappers {
    public static Wrapper<?> wrap(Object value, Class<?> valueClass, ClassHelper classHelper) {
        AssertionUtil.assertNotNull(valueClass, (Object)classHelper);
        Class<?> boxedClass = ClassUtil.toBoxedPrimitiveTypeIfPossible(valueClass);
        AssertionUtil.assertTrue(value == null || boxedClass.isInstance(value), new Object[0]);
        if (Wrapper.class.isAssignableFrom(boxedClass)) {
            return (Wrapper)value;
        }
        Wrapper<?> result = Wrappers.wrapBasicObject(value, boxedClass);
        if (result == null && (result = Wrappers.wrapDomainObject(value, boxedClass, classHelper)) == null && (result = Wrappers.wrapEnumObject(value, boxedClass)) == null) {
            throw new WrapperException(Message.DOMA1007, valueClass.getName(), value);
        }
        return result;
    }

    protected static Wrapper<?> wrapBasicObject(Object value, Class<?> valueClass) {
        AssertionUtil.assertNotNull(valueClass);
        if (valueClass == String.class) {
            return new StringWrapper((String)value);
        }
        if (valueClass == Integer.class) {
            return new IntegerWrapper((Integer)value);
        }
        if (valueClass == Long.class) {
            return new LongWrapper((Long)value);
        }
        if (valueClass == BigDecimal.class) {
            return new BigDecimalWrapper((BigDecimal)value);
        }
        if (valueClass == java.util.Date.class) {
            return new UtilDateWrapper((java.util.Date)value);
        }
        if (valueClass == Date.class) {
            return new DateWrapper((Date)value);
        }
        if (valueClass == Timestamp.class) {
            return new TimestampWrapper((Timestamp)value);
        }
        if (valueClass == Time.class) {
            return new TimeWrapper((Time)value);
        }
        if (valueClass == Boolean.class) {
            return new BooleanWrapper((Boolean)value);
        }
        if (valueClass == Array.class) {
            return new ArrayWrapper((Array)value);
        }
        if (valueClass == BigInteger.class) {
            return new BigIntegerWrapper((BigInteger)value);
        }
        if (valueClass == Blob.class) {
            return new BlobWrapper((Blob)value);
        }
        if (valueClass == byte[].class) {
            return new BytesWrapper((byte[])value);
        }
        if (valueClass == Byte.class) {
            return new ByteWrapper((Byte)value);
        }
        if (valueClass == Clob.class) {
            return new ClobWrapper((Clob)value);
        }
        if (valueClass == Double.class) {
            return new DoubleWrapper((Double)value);
        }
        if (valueClass == Float.class) {
            return new FloatWrapper((Float)value);
        }
        if (valueClass == NClob.class) {
            return new NClobWrapper((NClob)value);
        }
        if (valueClass == Short.class) {
            return new ShortWrapper((Short)value);
        }
        return null;
    }

    protected static Wrapper<?> wrapEnumObject(Object value, Class<?> valueClass) {
        AssertionUtil.assertNotNull(valueClass);
        if (valueClass.isEnum() || Enum.class.isAssignableFrom(valueClass)) {
            return new EnumWrapper<Enum>(valueClass, (Enum)value);
        }
        return null;
    }

    protected static <V, D> Wrapper<?> wrapDomainObject(Object value, Class<D> valueClass, ClassHelper classHelper) {
        Class domainValueClass;
        DomainType domainType = valueClass.isAnnotationPresent(Domain.class) || valueClass.isAnnotationPresent(EnumDomain.class) ? DomainTypeFactory.getDomainType(valueClass, classHelper) : DomainTypeFactory.getExternalDomainType(valueClass, classHelper);
        if (domainType == null) {
            return null;
        }
        Object domainValue = domainType.getWrapper(value).get();
        Wrapper<?> result = Wrappers.wrapBasicObject(domainValue, domainValueClass = domainType.getValueClass());
        if (result == null) {
            result = Wrappers.wrapEnumObject(domainValue, domainValueClass);
        }
        return result;
    }
}

