/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.seasar.doma.internal.util.AssertionUtil;

public final class GenericsUtil {
    public static Class<?> inferTypeArgument(Class<?> clazz, TypeVariable<?> typeVariable) {
        AssertionUtil.assertNotNull(clazz, typeVariable);
        TypeArgumentInferrer inferrer = new TypeArgumentInferrer(clazz, typeVariable);
        Type arg = inferrer.infer();
        if (arg instanceof Class) {
            return (Class)arg;
        }
        return null;
    }

    protected static class TypeArgumentInferrer {
        protected final Class<?> clazz;
        protected final GenericDeclaration genericDeclaration;
        protected final int index;

        public TypeArgumentInferrer(Class<?> clazz, TypeVariable<?> typeVariable) {
            this.clazz = clazz;
            this.genericDeclaration = typeVariable.getGenericDeclaration();
            this.index = this.getTypeParameterIndex(this.genericDeclaration, typeVariable);
        }

        private int getTypeParameterIndex(GenericDeclaration genericDeclaration, TypeVariable<?> typeVariable) {
            TypeVariable<?>[] types = genericDeclaration.getTypeParameters();
            int len = types.length;
            for (int i = 0; i < len; ++i) {
                if (types[i] != typeVariable) continue;
                return i;
            }
            return 0;
        }

        public Type infer() {
            Type arg;
            Class<?> superclass = this.clazz.getSuperclass();
            Type superclassType = this.clazz.getGenericSuperclass();
            if (superclass != null && (arg = this.getTypeArgumentRecursive(superclass, superclassType)) != null) {
                return arg;
            }
            Class<?>[] interfaces = this.clazz.getInterfaces();
            Type[] interfaceTypes = this.clazz.getGenericInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Type arg2 = this.getTypeArgumentRecursive(interfaces[i], interfaceTypes[i]);
                if (arg2 == null) continue;
                return arg2;
            }
            return null;
        }

        protected Type getTypeArgumentRecursive(Class<?> clazz, Type type) {
            if (clazz == null) {
                return null;
            }
            Type arg = this.getTypeArgument(clazz, type);
            if (arg != null) {
                return arg;
            }
            Class<?> superclass = clazz.getSuperclass();
            Type superclassType = clazz.getGenericSuperclass();
            if (superclass != null && (arg = this.getTypeArgumentRecursive(superclass, superclassType)) != null) {
                return arg;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            Type[] interfaceTypes = clazz.getGenericInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                arg = this.getTypeArgumentRecursive(interfaces[i], interfaceTypes[i]);
                if (arg == null) continue;
                return arg;
            }
            return null;
        }

        protected Type getTypeArgument(Class<?> clazz, Type type) {
            ParameterizedType parameterizedType;
            Type[] args;
            if (this.genericDeclaration == clazz && type instanceof ParameterizedType && this.index < (args = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length) {
                return args[this.index];
            }
            return null;
        }
    }
}

