/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVMapConcurrent;
import org.h2.mvstore.MVStore;
import org.h2.util.New;

public class TransactionStore {
    private static final String LAST_TRANSACTION_ID = "lastTransactionId";
    final MVStore store;
    final MVMap<Long, Object[]> openTransactions;
    final HashMap<Long, Transaction> openTransactionMap = New.hashMap();
    final MVMap<long[], Object[]> undoLog;
    long lockTimeout;
    private final MVMap<String, String> settings;
    private long lastTransactionIdStored;
    private long lastTransactionId;

    public TransactionStore(MVStore mVStore) {
        this.store = mVStore;
        this.settings = mVStore.openMap("settings");
        this.openTransactions = mVStore.openMap("openTransactions", new MVMapConcurrent.Builder());
        this.undoLog = mVStore.openMap("undoLog", new MVMapConcurrent.Builder());
        this.init();
    }

    private void init() {
        Long l;
        String string = this.settings.get(LAST_TRANSACTION_ID);
        if (string != null) {
            this.lastTransactionIdStored = this.lastTransactionId = Long.parseLong(string);
        }
        if ((l = this.openTransactions.lastKey()) != null && l > this.lastTransactionId) {
            throw DataUtils.newIllegalStateException("Last transaction not stored", new Object[0]);
        }
        Cursor<Object> cursor = this.openTransactions.keyIterator(null);
        while (cursor.hasNext()) {
            long l2 = cursor.next();
            Object[] objectArray = this.openTransactions.get(l2);
            int n = (Integer)objectArray[0];
            String string2 = (String)objectArray[1];
            long[] lArray = new long[]{l2 + 1L, 0L};
            long[] lArray2 = this.undoLog.floorKey(lArray);
            if (lArray2 == null || lArray2[0] != l2) continue;
            Transaction transaction = new Transaction(this, l2, n, string2, lArray2[1]);
            this.openTransactionMap.put(l2, transaction);
        }
    }

    public synchronized List<Transaction> getOpenTransactions() {
        ArrayList<Transaction> arrayList = New.arrayList();
        arrayList.addAll(this.openTransactionMap.values());
        return arrayList;
    }

    public synchronized void close() {
        this.settings.put(LAST_TRANSACTION_ID, "" + this.lastTransactionId);
        this.store.commit();
    }

    public synchronized Transaction begin() {
        this.store.incrementVersion();
        long l = this.lastTransactionId++;
        if (this.lastTransactionId > this.lastTransactionIdStored) {
            this.lastTransactionIdStored += 32L;
            this.settings.put(LAST_TRANSACTION_ID, "" + this.lastTransactionIdStored);
        }
        int n = 0;
        Object[] objectArray = new Object[]{n, null};
        this.openTransactions.put(l, objectArray);
        Transaction transaction = new Transaction(this, l, n, null, 0L);
        this.openTransactionMap.put(l, transaction);
        return transaction;
    }

    void prepare(long l) {
        Object[] objectArray = this.openTransactions.get(l);
        Object[] objectArray2 = new Object[]{1, objectArray[1]};
        this.openTransactions.put(l, objectArray2);
        this.store.commit();
    }

    void setTransactionName(long l, String string) {
        Object[] objectArray = this.openTransactions.get(l);
        Object[] objectArray2 = new Object[]{objectArray[0], string};
        this.openTransactions.put(l, objectArray2);
        this.store.commit();
    }

    void commit(long l, long l2) {
        this.store.incrementVersion();
        for (long i = 0L; i < l2; ++i) {
            Object[] objectArray = this.undoLog.get(new long[]{l, i});
            int n = (Integer)objectArray[0];
            if (n == 0) {
                Object object;
                int n2 = (Integer)objectArray[1];
                MVMap<String, String> mVMap = this.store.getMetaMap();
                String string = (String)mVMap.get("map." + n2);
                String string2 = DataUtils.parseMap(string).get("name");
                MVMap mVMap2 = this.store.openMap(string2);
                Object[] objectArray2 = (Object[])mVMap2.get(object = objectArray[2]);
                if (objectArray2[2] == null) {
                    mVMap2.remove(object);
                }
            }
            this.undoLog.remove(i);
        }
        this.openTransactions.remove(l);
        this.openTransactionMap.remove(l);
        this.store.commit();
    }

    void rollback(long l, long l2) {
        this.rollbackTo(l, l2, 0L);
        this.openTransactions.remove(l);
        this.openTransactionMap.remove(l);
        this.store.commit();
    }

    void rollbackTo(long l, long l2, long l3) {
        this.store.incrementVersion();
        for (long i = l2 - 1L; i >= l3; --i) {
            Object object;
            Object[] objectArray = this.undoLog.get(new long[]{l, i});
            int n = (Integer)objectArray[1];
            MVMap<String, String> mVMap = this.store.getMetaMap();
            String string = (String)mVMap.get("map." + n);
            String string2 = DataUtils.parseMap(string).get("name");
            MVMap<Object, Object[]> mVMap2 = this.store.openMap(string2);
            Object[] objectArray2 = (Object[])mVMap2.get(object = objectArray[2]);
            if (objectArray2 != null) {
                Long l4 = (Long)objectArray2[1];
                if (l4 == null) {
                    mVMap2.remove(object);
                } else if (l4 < mVMap2.getCreateVersion()) {
                    mVMap2.remove(object);
                } else {
                    MVMap mVMap3 = mVMap2.openVersion(l4);
                    Object[] objectArray3 = (Object[])mVMap3.get(object);
                    if (objectArray3 == null) {
                        mVMap2.remove(object);
                    } else {
                        mVMap2.put(object, objectArray3);
                    }
                }
            }
            this.undoLog.remove(i);
        }
        this.store.commit();
    }

    public <A, B> MVMap<A, B> openMap(String string, MVMap.Builder<A, B> builder) {
        return this.store.openMap(string, builder);
    }

    public static class TransactionMap<K, V> {
        private Transaction transaction;
        private final int mapId;
        private final MVMap<K, Object[]> mapWrite;
        private final MVMap<K, Object[]> mapRead;

        TransactionMap(Transaction transaction, String string, long l) {
            this.transaction = transaction;
            this.mapWrite = transaction.store.store.openMap(string);
            this.mapId = this.mapWrite.getId();
            this.mapRead = l >= 0L ? this.mapWrite.openVersion(l) : this.mapWrite;
        }

        public long getSize() {
            long l = 0L;
            Cursor<Object> cursor = this.mapRead.keyIterator(null);
            while (cursor.hasNext()) {
                K k = cursor.next();
                if (this.get(k) == null) continue;
                ++l;
            }
            return l;
        }

        private void checkOpen() {
            this.transaction.checkOpen();
        }

        public V remove(K k) {
            return this.set(k, null);
        }

        public V put(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            return this.set(k, v);
        }

        private V set(K k, V v) {
            this.checkOpen();
            long l = 0L;
            while (true) {
                V v2 = this.get(k);
                boolean bl = this.trySet(k, v, false);
                if (bl) {
                    return v2;
                }
                long l2 = this.transaction.store.lockTimeout;
                if (l2 == 0L) {
                    throw DataUtils.newIllegalStateException("Lock timeout", new Object[0]);
                }
                if (l == 0L) {
                    l = System.currentTimeMillis();
                    continue;
                }
                long l3 = System.currentTimeMillis() - l;
                if (l3 > l2) {
                    throw DataUtils.newIllegalStateException("Lock timeout", new Object[0]);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public boolean tryRemove(K k) {
            return this.trySet(k, null, false);
        }

        public boolean tryPut(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            return this.trySet(k, v, false);
        }

        public boolean trySet(K k, V v, boolean bl) {
            Object[] objectArray;
            MVMap<K, Object[]> mVMap = this.mapRead;
            Object[] objectArray2 = this.mapWrite.get(k);
            if (bl && !this.mapWrite.areValuesEqual(objectArray = mVMap.get(k), objectArray2)) {
                long l = (Long)objectArray2[0];
                if (l == this.transaction.transactionId) {
                    if (v == null) {
                        return true;
                    }
                    if (objectArray2[2] != null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            long l = this.transaction.store.store.getCurrentVersion() - 1L;
            int n = objectArray2 == null || objectArray2[2] == null ? (v == null ? 2 : 1) : (v == null ? 0 : 2);
            Object[] objectArray3 = new Object[]{this.transaction.transactionId, l, v};
            if (objectArray2 == null) {
                objectArray3[1] = null;
                Object[] objectArray4 = this.mapWrite.putIfAbsent(k, objectArray3);
                if (objectArray4 == null) {
                    this.transaction.log(n, this.mapId, k);
                    return true;
                }
                return false;
            }
            long l2 = (Long)objectArray2[0];
            if (l2 == this.transaction.transactionId) {
                if (this.mapWrite.replace(k, objectArray2, objectArray3)) {
                    if (objectArray2[1] == null) {
                        this.transaction.log(n, this.mapId, k);
                    } else {
                        long l3 = (Long)objectArray2[1];
                        if (l3 != l) {
                            this.transaction.log(n, this.mapId, k);
                        }
                    }
                    return true;
                }
                return false;
            }
            boolean bl2 = this.transaction.store.openTransactions.containsKey(l2);
            if (!bl2) {
                if (this.mapWrite.replace(k, objectArray2, objectArray3)) {
                    this.transaction.log(n, this.mapId, k);
                    return true;
                }
                return false;
            }
            return false;
        }

        public V get(K k) {
            return this.get(k, this.mapRead);
        }

        public V getLatest(K k) {
            return this.get(k, this.mapWrite);
        }

        public V get(K k, MVMap<K, Object[]> mVMap) {
            this.checkOpen();
            Object[] objectArray;
            while ((objectArray = mVMap.get(k)) != null) {
                long l = (Long)objectArray[0];
                if (l == this.transaction.transactionId) {
                    return (V)objectArray[2];
                }
                boolean bl = this.transaction.store.openTransactions.containsKey(l);
                if (!bl) {
                    return (V)objectArray[2];
                }
                l = (Long)objectArray[0];
                if (objectArray[1] == null) {
                    return null;
                }
                long l2 = (Long)objectArray[1];
                mVMap = this.mapWrite.openVersion(l2);
            }
            return null;
        }
    }

    public static class Transaction {
        public static final int STATUS_OPEN = 0;
        public static final int STATUS_PREPARED = 1;
        public static final int STATUS_CLOSED = 2;
        static final int OP_REMOVE = 0;
        static final int OP_ADD = 1;
        static final int OP_SET = 2;
        final TransactionStore store;
        final long transactionId;
        private int status;
        private String name;
        private long logId;

        Transaction(TransactionStore transactionStore, long l, int n, String string, long l2) {
            this.store = transactionStore;
            this.transactionId = l;
            this.status = n;
            this.name = string;
            this.logId = l2;
        }

        public long getId() {
            return this.transactionId;
        }

        public int getStatus() {
            return this.status;
        }

        public void setName(String string) {
            this.checkOpen();
            this.store.setTransactionName(this.transactionId, string);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public long setSavepoint() {
            this.checkOpen();
            this.store.store.incrementVersion();
            return this.logId;
        }

        void log(int n, int n2, Object object) {
            long[] lArray = new long[]{this.transactionId, this.logId++};
            Object[] objectArray = new Object[]{n, n2, object};
            this.store.undoLog.put(lArray, objectArray);
        }

        public <K, V> TransactionMap<K, V> openMap(String string) {
            this.checkOpen();
            return new TransactionMap(this, string, -1L);
        }

        public <K, V> TransactionMap<K, V> openMap(String string, long l) {
            this.checkOpen();
            return new TransactionMap(this, string, l);
        }

        public void rollbackToSavepoint(long l) {
            this.checkOpen();
            this.store.rollbackTo(this.transactionId, this.logId, l);
            this.logId = l;
        }

        public void prepare() {
            this.checkOpen();
            this.store.prepare(this.transactionId);
            this.status = 1;
        }

        public void commit() {
            if (this.status != 2) {
                this.store.commit(this.transactionId, this.logId);
                this.status = 2;
            }
        }

        public void rollback() {
            if (this.status != 2) {
                this.store.rollback(this.transactionId, this.logId);
                this.status = 2;
            }
        }

        void checkOpen() {
            if (this.status != 0) {
                throw DataUtils.newIllegalStateException("Transaction is closed", new Object[0]);
            }
        }
    }
}

