/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.SerializeUtil;

public class SessionState {
    private Map binaryData;
    private Map accessedData;
    private Map persistedData;

    public SessionState(Map binaryData) {
        this.binaryData = binaryData;
        int size = Math.max(binaryData.size(), 20);
        this.accessedData = new HashMap(size);
        this.persistedData = new HashMap(size);
    }

    public synchronized Object getAttribute(String name) {
        if (this.accessedData.containsKey(name)) {
            return this.accessedData.get(name);
        }
        if (this.persistedData.containsKey(name)) {
            Object value = this.persistedData.get(name);
            this.accessedData.put(name, value);
            return value;
        }
        if (this.binaryData.containsKey(name)) {
            byte[] binary = (byte[])this.binaryData.get(name);
            Object value = SerializeUtil.fromBinaryToObject((byte[])binary);
            this.accessedData.put(name, value);
            return value;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        LinkedHashSet set = new LinkedHashSet();
        Iterator i = this.accessedData.keySet().iterator();
        while (i.hasNext()) {
            set.add(i.next());
        }
        i = this.binaryData.keySet().iterator();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return new EnumerationAdapter(set.iterator());
    }

    public Enumeration getAccessedAttributeNames() {
        return new EnumerationAdapter(this.accessedData.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.accessedData.put(name, value);
    }

    public synchronized void persisted() {
        Iterator i = this.accessedData.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = this.accessedData.get(key);
            if (value == null) {
                this.persistedData.remove(key);
                this.binaryData.remove(key);
                continue;
            }
            this.persistedData.put(key, value);
        }
        this.accessedData.clear();
    }

    public boolean needInsert(String name) {
        if (!this.accessedData.containsKey(name)) {
            return false;
        }
        Object value = this.accessedData.get(name);
        return value != null && !this.binaryData.containsKey(name) && !this.persistedData.containsKey(name);
    }

    public boolean needUpdate(String name) {
        if (!this.accessedData.containsKey(name)) {
            return false;
        }
        Object value = this.accessedData.get(name);
        return value != null && (this.binaryData.containsKey(name) || this.persistedData.containsKey(name));
    }

    public boolean needDelete(String name) {
        if (!this.accessedData.containsKey(name)) {
            return false;
        }
        Object value = this.accessedData.get(name);
        return value == null && (this.binaryData.containsKey(name) || this.persistedData.containsKey(name));
    }

    protected Object getPersistedAttribute(String name) {
        return this.persistedData.get(name);
    }
}

