/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.type.WrapperType;
import org.seasar.doma.internal.util.AssertionUtil;

public class BasicType
extends AbstractDataType {
    protected WrapperType wrapperType;

    public BasicType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public WrapperType getWrapperType() {
        return this.wrapperType;
    }

    public String getDefaultValue() {
        switch (this.typeMirror.getKind()) {
            case BOOLEAN: {
                return String.valueOf(false);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: {
                return "0";
            }
        }
        return "null";
    }

    public static BasicType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        BasicType basicType = new BasicType(type, env);
        WrapperType wrapperType = WrapperType.newInstance(basicType, env);
        if (wrapperType == null) {
            return null;
        }
        basicType.wrapperType = wrapperType;
        return basicType;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitBasicType(this, p);
    }
}

