/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.BlockNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.EndNode;
import org.seasar.doma.internal.jdbc.sql.node.IfBlockNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class IfBlockNode
extends AbstractSqlNode
implements BlockNode {
    protected IfNode ifNode;
    protected List<ElseifNode> elseifNodes = new ArrayList<ElseifNode>();
    protected ElseNode elseNode;
    protected EndNode endNode;

    public void setIfNode(IfNode ifNode) {
        this.ifNode = ifNode;
        this.addNodeInternal(ifNode);
    }

    public IfNode getIfNode() {
        return this.ifNode;
    }

    public void addElseifNode(ElseifNode elseIfNode) {
        this.elseifNodes.add(elseIfNode);
        this.addNodeInternal(elseIfNode);
    }

    public List<ElseifNode> getElseifNodes() {
        return this.elseifNodes;
    }

    public void setElseNode(ElseNode elseNode) {
        this.elseNode = elseNode;
        this.addNodeInternal(elseNode);
    }

    public ElseNode getElseNode() {
        return this.elseNode;
    }

    @Override
    public void setEndNode(EndNode endNode) {
        this.endNode = endNode;
        this.addNodeInternal(endNode);
    }

    public EndNode getEndNode() {
        return this.endNode;
    }

    public boolean isElseNodeExistent() {
        return this.elseNode != null;
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    protected void addNodeInternal(SqlNode child) {
        if (child != null) {
            super.addNode(child);
        }
    }

    @Override
    public IfBlockNode copy() {
        IfBlockNode clone = new IfBlockNode();
        if (this.ifNode != null) {
            clone.ifNode = this.ifNode.copy();
        }
        for (ElseifNode elseifNode : this.elseifNodes) {
            clone.elseifNodes.add(elseifNode.copy());
        }
        if (this.elseNode != null) {
            clone.elseNode = this.elseNode.copy();
        }
        if (this.endNode != null) {
            clone.endNode = this.endNode.copy();
        }
        for (SqlNode child : this.children) {
            clone.addNodeInternal(child.copy());
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof IfBlockNodeVisitor) {
            IfBlockNodeVisitor v = (IfBlockNodeVisitor)visitor;
            return v.visitIfBlockNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        buf.append("]");
        return buf.toString();
    }
}

