/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import org.seasar.doma.internal.jdbc.command.ScriptTokenType;
import org.seasar.doma.internal.util.AssertionUtil;

public class ScriptTokenizer {
    protected String blockDelimiter;
    protected String line;
    protected int pos;
    protected int nextPos;
    protected int length;
    protected String token;
    protected ScriptTokenType type;
    protected boolean blockCommentStarted;

    public ScriptTokenizer(String blockDelimiter) {
        this.blockDelimiter = blockDelimiter;
        this.type = ScriptTokenType.END_OF_LINE;
    }

    public void addLine(String line) {
        if (line == null) {
            this.type = ScriptTokenType.END_OF_FILE;
            return;
        }
        this.line = line;
        this.length = line.length();
        this.pos = 0;
        this.nextPos = 0;
        if (this.blockCommentStarted) {
            this.type = ScriptTokenType.BLOCK_COMMENT;
        } else if (line.trim().equalsIgnoreCase(this.blockDelimiter)) {
            this.type = ScriptTokenType.BLOCK_DELIMITER;
            this.nextPos = this.length;
        } else {
            this.peek(this.pos);
        }
    }

    protected void peek(int index) {
        if (index < this.length) {
            char c = this.line.charAt(index);
            if (c == '\'') {
                this.type = ScriptTokenType.QUOTE;
                this.pos = index;
                this.nextPos = index + 1;
            } else {
                int nextIndex = index + 1;
                if (nextIndex < this.length) {
                    char c2 = this.line.charAt(nextIndex);
                    if (c == '-' && c2 == '-') {
                        this.type = ScriptTokenType.LINE_COMMENT;
                        this.pos = index;
                        this.nextPos = index + 2;
                    } else if (c == '/' && c2 == '*') {
                        this.type = ScriptTokenType.START_OF_BLOCK_COMMENT;
                        this.pos = index;
                        this.nextPos = index + 2;
                    } else {
                        this.peekChar(index, c);
                    }
                } else {
                    this.peekChar(index, c);
                }
            }
        } else {
            this.type = ScriptTokenType.END_OF_LINE;
            this.pos = this.length;
            this.nextPos = this.length;
        }
    }

    protected void peekChar(int index, char c) {
        this.type = c == ';' ? ScriptTokenType.STATEMENT_DELIMITER : (ScriptTokenizer.isOther(c) ? ScriptTokenType.OTHER : ScriptTokenType.WORD);
        this.pos = index;
        this.nextPos = index + 1;
    }

    public ScriptTokenType nextToken() {
        switch (this.type) {
            case END_OF_FILE: {
                this.token = null;
                this.type = ScriptTokenType.END_OF_FILE;
                return ScriptTokenType.END_OF_FILE;
            }
            case END_OF_LINE: {
                this.token = "";
                this.type = ScriptTokenType.END_OF_LINE;
                return ScriptTokenType.END_OF_LINE;
            }
            case BLOCK_DELIMITER: {
                this.token = this.line;
                this.type = ScriptTokenType.END_OF_LINE;
                return ScriptTokenType.BLOCK_DELIMITER;
            }
            case STATEMENT_DELIMITER: {
                this.token = this.line.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return ScriptTokenType.STATEMENT_DELIMITER;
            }
            case LINE_COMMENT: {
                this.token = this.line.substring(this.pos, this.length);
                this.type = ScriptTokenType.END_OF_LINE;
                return ScriptTokenType.LINE_COMMENT;
            }
            case START_OF_BLOCK_COMMENT: {
                this.token = this.line.substring(this.pos, this.nextPos);
                this.type = ScriptTokenType.BLOCK_COMMENT;
                this.pos += 2;
                this.nextPos = this.pos + 2;
                return ScriptTokenType.START_OF_BLOCK_COMMENT;
            }
            case BLOCK_COMMENT: {
                for (int i = this.nextPos; i < this.length; ++i) {
                    char c = this.line.charAt(i);
                    int nextIndex = i + 1;
                    if (nextIndex >= this.length) continue;
                    char c2 = this.line.charAt(nextIndex);
                    if (c != '*' || c2 != '/') continue;
                    this.blockCommentStarted = false;
                    this.token = this.line.substring(this.pos, i);
                    this.type = ScriptTokenType.END_OF_BLOCK_COMMENT;
                    this.pos = i;
                    this.nextPos = i + 2;
                    return ScriptTokenType.BLOCK_COMMENT;
                }
                this.blockCommentStarted = true;
                this.token = this.line.substring(this.pos, this.length);
                this.type = ScriptTokenType.END_OF_LINE;
                return ScriptTokenType.BLOCK_COMMENT;
            }
            case END_OF_BLOCK_COMMENT: {
                this.token = this.line.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return ScriptTokenType.END_OF_BLOCK_COMMENT;
            }
            case QUOTE: {
                for (int i = this.nextPos; i < this.length; ++i) {
                    char c = this.line.charAt(i);
                    if (c != '\'') continue;
                    if (++i >= this.length) {
                        this.token = this.line.substring(this.pos, i);
                        this.type = ScriptTokenType.END_OF_LINE;
                        return ScriptTokenType.QUOTE;
                    }
                    if (this.line.charAt(i) == '\'') continue;
                    this.token = this.line.substring(this.pos, i);
                    this.peek(i);
                    return ScriptTokenType.QUOTE;
                }
                this.token = this.line.substring(this.pos, this.length);
                this.type = ScriptTokenType.END_OF_LINE;
                return ScriptTokenType.QUOTE;
            }
            case WORD: {
                int wordStartPos = this.pos;
                while (this.type == ScriptTokenType.WORD && this.pos < this.length) {
                    this.peek(this.nextPos);
                }
                this.token = this.line.substring(wordStartPos, this.pos);
                return ScriptTokenType.WORD;
            }
            case OTHER: {
                int otherStartPos = this.pos;
                while (this.type == ScriptTokenType.OTHER && this.pos < this.length) {
                    this.peek(this.nextPos);
                }
                this.token = this.line.substring(otherStartPos, this.pos);
                return ScriptTokenType.OTHER;
            }
        }
        AssertionUtil.assertUnreachable(this.type.name());
        return null;
    }

    protected static boolean isOther(char c) {
        return Character.isWhitespace(c) || c == '=' || c == '?' || c == '<' || c == '>' || c == '(' || c == ')' || c == '!' || c == '*' || c == '-' || c == ',';
    }

    public String getToken() {
        return this.token;
    }
}

