/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.util.Map;
import ognl.MethodFailedException;
import ognl.Ognl;
import ognl.OgnlException;
import org.seasar.framework.exception.OgnlRuntimeException;
import org.seasar.framework.unit.Expression;
import org.seasar.framework.util.OgnlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlExpression
implements Expression {
    private final String source;
    private final Object root;
    private final Map<String, Object> context;
    private Exception exception;

    public OgnlExpression(String source, Object root, Map<String, Object> context) {
        this.source = source;
        this.root = root;
        this.context = context;
    }

    @Override
    public Object evaluate() {
        Object exp = OgnlUtil.parseExpression((String)this.source);
        return OgnlUtil.getValue((Object)exp, this.context, (Object)this.root);
    }

    @Override
    public Object evaluateNoException() {
        try {
            return Ognl.getValue((String)this.source, this.context, (Object)this.root);
        }
        catch (OgnlException e) {
            this.exception = e;
            return null;
        }
    }

    @Override
    public boolean isMethodFailed() {
        return this.hasException() && this.exception instanceof MethodFailedException;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void throwExceptionIfNecessary() {
        if (this.hasException()) {
            throw new OgnlRuntimeException(this.exception.getCause() == null ? this.exception : this.exception.getCause());
        }
    }

    protected boolean hasException() {
        return this.exception != null;
    }
}

