/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.query.BatchModifyQuery;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;

public abstract class SqlFileBatchModifyQuery<E>
implements BatchModifyQuery {
    protected final Class<E> elementClass;
    protected final SqlKind kind;
    protected Method method;
    protected Config config;
    protected String sqlFilePath;
    protected String parameterName;
    protected String callerClassName;
    protected String callerMethodName;
    protected SqlFile sqlFile;
    protected boolean optimisticLockCheckRequired;
    protected boolean executable;
    protected SqlExecutionSkipCause sqlExecutionSkipCause = SqlExecutionSkipCause.BATCH_TARGET_NONEXISTENT;
    protected int queryTimeout;
    protected int batchSize;
    protected List<E> elements;
    protected E currentEntity;
    protected List<PreparedSql> sqls;

    protected SqlFileBatchModifyQuery(Class<E> elementClass, SqlKind kind) {
        AssertionUtil.assertNotNull(elementClass, (Object)kind);
        this.elementClass = elementClass;
        this.kind = kind;
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.method, this.config, this.sqlFilePath, this.parameterName, this.callerClassName, this.callerMethodName, this.elements, this.sqls);
    }

    protected void prepareSqlFile() {
        this.sqlFile = this.config.getSqlFileRepository().getSqlFile(this.sqlFilePath, this.config.getDialect());
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
        if (this.batchSize <= 0) {
            this.batchSize = this.config.getBatchSize();
        }
    }

    protected void prepareSql() {
        Value value = new Value(this.elementClass, this.currentEntity);
        ExpressionEvaluator evaluator = new ExpressionEvaluator(Collections.singletonMap(this.parameterName, value), this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, this.kind, this.sqlFile.getPath(), evaluator);
        PreparedSql sql = sqlBuilder.build(this.sqlFile.getSqlNode());
        this.sqls.add(sql);
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setElements(Iterable<E> elements) {
        AssertionUtil.assertNotNull(elements);
        if (elements instanceof Collection) {
            this.elements = new ArrayList((Collection)elements);
        } else {
            this.elements = new ArrayList();
            for (E element : elements) {
                this.elements.add(element);
            }
        }
        this.sqls = new ArrayList<PreparedSql>(this.elements.size());
    }

    public List<E> getEntities() {
        return this.elements;
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public abstract void setEntityType(EntityType<E> var1);

    @Override
    public PreparedSql getSql() {
        return this.sqls.get(0);
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public List<PreparedSql> getSqls() {
        return this.sqls;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return false;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.sqlExecutionSkipCause;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public String toString() {
        return this.sqls.toString();
    }
}

