/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.SqlLogRegistry;
import org.seasar.extension.jdbc.SqlLogRegistryLocator;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.impl.SqlLogImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;

public class BasicHandler {
    private DataSource dataSource;
    private String sql;
    private StatementFactory statementFactory = BasicStatementFactory.INSTANCE;
    protected Class loggerClass = BasicHandler.class;

    public BasicHandler() {
    }

    public BasicHandler(DataSource ds, String sql) {
        this(ds, sql, BasicStatementFactory.INSTANCE);
    }

    public BasicHandler(DataSource ds, String sql, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setStatementFactory(statementFactory);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected Connection getConnection() {
        if (this.dataSource == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return DataSourceUtil.getConnection(this.dataSource);
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        if (this.sql == null) {
            throw new EmptyRuntimeException("sql");
        }
        return this.statementFactory.createPreparedStatement(connection, this.sql);
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, Class[] argTypes) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            ValueType valueType = this.getValueType(argTypes[i]);
            try {
                valueType.bindValue(ps, i + 1, args[i]);
                continue;
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    protected Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            argTypes[i] = arg.getClass();
        }
        return argTypes;
    }

    protected String getCompleteSql(Object[] args) {
        return BindVariableUtil.getCompleteSql(this.sql, args);
    }

    protected String getBindVariableText(Object bindVariable) {
        return BindVariableUtil.getBindVariableText(bindVariable);
    }

    protected ValueType getValueType(Class clazz) {
        return ValueTypes.getValueType(clazz);
    }

    protected void logSql(Object[] args, Class[] argTypes) {
        Logger logger = Logger.getLogger((Class)this.loggerClass);
        SqlLogRegistry sqlLogRegistry = SqlLogRegistryLocator.getInstance();
        if (logger.isDebugEnabled() || sqlLogRegistry != null) {
            String completeSql = this.getCompleteSql(args);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)completeSql);
            }
            if (sqlLogRegistry != null) {
                SqlLogImpl sqlLog = new SqlLogImpl(this.getSql(), completeSql, args, argTypes);
                sqlLogRegistry.add(sqlLog);
            }
        }
    }

    public Class getLoggerClass() {
        return this.loggerClass;
    }

    public void setLoggerClass(Class loggerClass) {
        this.loggerClass = loggerClass;
    }
}

