/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.util.LikeUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractWhere<T extends AbstractWhere<T>>
implements Where {
    protected StringBuilder criteriaSb = new StringBuilder(100);
    protected List<Object> paramList = new ArrayList<Object>();
    protected List<String> propertyNameList = new ArrayList<String>();
    protected boolean excludesWhitespace;

    public T excludesWhitespace() {
        this.excludesWhitespace = true;
        return (T)this;
    }

    @Deprecated
    public T ignoreWhitespace() {
        return this.excludesWhitespace();
    }

    public T eq(CharSequence propertyName, Object value) {
        this.assertPropertyName(propertyName);
        value = this.normalize(value);
        if (ConditionType.EQ.isTarget(value)) {
            this.addCondition(ConditionType.EQ, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T ne(CharSequence propertyName, Object value) {
        this.assertPropertyName(propertyName);
        value = this.normalize(value);
        if (ConditionType.NE.isTarget(value)) {
            this.addCondition(ConditionType.NE, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T lt(CharSequence propertyName, Object value) {
        this.assertPropertyName(propertyName);
        value = this.normalize(value);
        if (ConditionType.LT.isTarget(value)) {
            this.addCondition(ConditionType.LT, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T le(CharSequence propertyName, Object value) {
        this.assertPropertyName(propertyName);
        value = this.normalize(value);
        if (ConditionType.LE.isTarget(value)) {
            this.addCondition(ConditionType.LE, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T gt(CharSequence propertyName, Object value) {
        this.assertPropertyName(propertyName);
        value = this.normalize(value);
        if (ConditionType.GT.isTarget(value)) {
            this.addCondition(ConditionType.GT, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T ge(CharSequence propertyName, Object value) {
        this.assertPropertyName(propertyName);
        value = this.normalize(value);
        if (ConditionType.GE.isTarget(value)) {
            this.addCondition(ConditionType.GE, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T in(CharSequence propertyName, Object ... values) {
        this.assertPropertyName(propertyName);
        values = this.normalizeArray(values);
        if (ConditionType.IN.isTarget(values)) {
            this.addCondition(ConditionType.IN, ((Object)propertyName).toString(), values);
        }
        return (T)this;
    }

    public T in(CharSequence propertyName, Collection<?> values) {
        this.assertPropertyName(propertyName);
        values = this.normalizeList(values);
        if (ConditionType.IN.isTarget(values)) {
            this.addCondition(ConditionType.IN, ((Object)propertyName).toString(), values);
        }
        return (T)this;
    }

    public T notIn(CharSequence propertyName, Object ... values) {
        this.assertPropertyName(propertyName);
        values = this.normalizeArray(values);
        if (ConditionType.NOT_IN.isTarget(values)) {
            this.addCondition(ConditionType.NOT_IN, ((Object)propertyName).toString(), values);
        }
        return (T)this;
    }

    public T notIn(CharSequence propertyName, Collection<?> values) {
        this.assertPropertyName(propertyName);
        values = this.normalizeList(values);
        if (ConditionType.NOT_IN.isTarget(values)) {
            this.addCondition(ConditionType.NOT_IN, ((Object)propertyName).toString(), values);
        }
        return (T)this;
    }

    public T like(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        Object normalizedValue = this.normalize(value);
        if (ConditionType.LIKE.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.LIKE, ((Object)propertyName).toString(), normalizedValue);
        }
        return (T)this;
    }

    public T like(CharSequence propertyName, String value, char escape) {
        this.assertPropertyName(propertyName);
        Object normalizedValue = this.normalize(value);
        if (ConditionType.LIKE_ESCAPE.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.LIKE_ESCAPE, ((Object)propertyName).toString(), new Object[]{normalizedValue, Character.valueOf(escape)});
        }
        return (T)this;
    }

    public T notLike(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        Object normalizedValue = this.normalize(value);
        if (ConditionType.NOT_LIKE.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.NOT_LIKE, ((Object)propertyName).toString(), normalizedValue);
        }
        return (T)this;
    }

    public T notLike(CharSequence propertyName, String value, char escape) {
        this.assertPropertyName(propertyName);
        Object normalizedValue = this.normalize(value);
        if (ConditionType.NOT_LIKE_ESCAPE.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.NOT_LIKE_ESCAPE, ((Object)propertyName).toString(), new Object[]{normalizedValue, Character.valueOf(escape)});
        }
        return (T)this;
    }

    public T starts(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        String normalizedValue = (String)String.class.cast(this.normalize(value));
        if (ConditionType.STARTS.isTarget(normalizedValue)) {
            if (!LikeUtil.containsWildcard(normalizedValue)) {
                this.addCondition(ConditionType.STARTS, ((Object)propertyName).toString(), normalizedValue);
            } else {
                this.addCondition(ConditionType.STARTS_ESCAPE, ((Object)propertyName).toString(), LikeUtil.escapeWildcard(normalizedValue));
            }
        }
        return (T)this;
    }

    public T notStarts(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        String normalizedValue = (String)String.class.cast(this.normalize(value));
        if (ConditionType.NOT_STARTS.isTarget(normalizedValue)) {
            if (!LikeUtil.containsWildcard(normalizedValue)) {
                this.addCondition(ConditionType.NOT_STARTS, ((Object)propertyName).toString(), normalizedValue);
            } else {
                this.addCondition(ConditionType.NOT_STARTS_ESCAPE, ((Object)propertyName).toString(), LikeUtil.escapeWildcard(normalizedValue));
            }
        }
        return (T)this;
    }

    public T ends(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        String normalizedValue = (String)String.class.cast(this.normalize(value));
        if (ConditionType.ENDS.isTarget(normalizedValue)) {
            if (!LikeUtil.containsWildcard(normalizedValue)) {
                this.addCondition(ConditionType.ENDS, ((Object)propertyName).toString(), normalizedValue);
            } else {
                this.addCondition(ConditionType.ENDS_ESCAPE, ((Object)propertyName).toString(), LikeUtil.escapeWildcard(normalizedValue));
            }
        }
        return (T)this;
    }

    public T notEnds(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        String normalizedValue = (String)String.class.cast(this.normalize(value));
        if (ConditionType.NOT_ENDS.isTarget(normalizedValue)) {
            if (!LikeUtil.containsWildcard(normalizedValue)) {
                this.addCondition(ConditionType.NOT_ENDS, ((Object)propertyName).toString(), normalizedValue);
            } else {
                this.addCondition(ConditionType.NOT_ENDS_ESCAPE, ((Object)propertyName).toString(), LikeUtil.escapeWildcard(normalizedValue));
            }
        }
        return (T)this;
    }

    public T contains(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        String normalizedValue = (String)String.class.cast(this.normalize(value));
        if (ConditionType.CONTAINS.isTarget(normalizedValue)) {
            if (!LikeUtil.containsWildcard(normalizedValue)) {
                this.addCondition(ConditionType.CONTAINS, ((Object)propertyName).toString(), normalizedValue);
            } else {
                this.addCondition(ConditionType.CONTAINS_ESCAPE, ((Object)propertyName).toString(), LikeUtil.escapeWildcard(normalizedValue));
            }
        }
        return (T)this;
    }

    public T notContains(CharSequence propertyName, String value) {
        this.assertPropertyName(propertyName);
        String normalizedValue = (String)String.class.cast(this.normalize(value));
        if (ConditionType.NOT_CONTAINS.isTarget(normalizedValue)) {
            if (!LikeUtil.containsWildcard(normalizedValue)) {
                this.addCondition(ConditionType.NOT_CONTAINS, ((Object)propertyName).toString(), normalizedValue);
            } else {
                this.addCondition(ConditionType.NOT_CONTAINS_ESCAPE, ((Object)propertyName).toString(), LikeUtil.escapeWildcard(normalizedValue));
            }
        }
        return (T)this;
    }

    public T isNull(CharSequence propertyName, Boolean value) {
        this.assertPropertyName(propertyName);
        if (ConditionType.IS_NULL.isTarget(value)) {
            this.addCondition(ConditionType.IS_NULL, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    public T isNotNull(CharSequence propertyName, Boolean value) {
        this.assertPropertyName(propertyName);
        if (ConditionType.IS_NOT_NULL.isTarget(value)) {
            this.addCondition(ConditionType.IS_NOT_NULL, ((Object)propertyName).toString(), value);
        }
        return (T)this;
    }

    @Override
    public String getCriteria() {
        return new String(this.criteriaSb);
    }

    @Override
    public Object[] getParams() {
        return this.paramList.toArray();
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNameList.toArray(new String[this.propertyNameList.size()]);
    }

    protected void addCondition(ConditionType conditionType, String propertyName, Object value) {
        if (this.criteriaSb.length() > 0) {
            this.criteriaSb.append(" and ");
        }
        this.criteriaSb.append(conditionType.getCondition(propertyName, value));
        int size = conditionType.addValue(this.paramList, value);
        for (int i = 0; i < size; ++i) {
            this.propertyNameList.add(propertyName);
        }
    }

    protected Object normalize(Object value) {
        if (this.excludesWhitespace && value instanceof String && StringUtil.isEmpty((String)((String)String.class.cast(value)).trim())) {
            return null;
        }
        return value;
    }

    protected Object[] normalizeArray(Object ... values) {
        if (!this.excludesWhitespace || values == null) {
            return values;
        }
        ArrayList<Object> list = CollectionsUtil.newArrayList(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object normalizedValue = this.normalize(values[i]);
            if (normalizedValue == null) continue;
            list.add(normalizedValue);
        }
        return list.toArray(new Object[list.size()]);
    }

    protected Collection<?> normalizeList(Collection<?> values) {
        if (!this.excludesWhitespace || values == null) {
            return values;
        }
        ArrayList<Object> list = CollectionsUtil.newArrayList(values.size());
        for (Object value : values) {
            Object normalizedValue = this.normalize(value);
            if (normalizedValue == null) continue;
            list.add(normalizedValue);
        }
        return list;
    }

    protected void assertPropertyName(CharSequence s) {
        if (s == null) {
            throw new NullPointerException("propertyName");
        }
    }
}

