/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.doma.internal.jdbc.sql.SqlTokenType;
import org.seasar.doma.internal.jdbc.sql.SqlTokenizer;
import org.seasar.doma.internal.jdbc.sql.node.AnonymousNode;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.BlockNode;
import org.seasar.doma.internal.jdbc.sql.node.CommentNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.EndNode;
import org.seasar.doma.internal.jdbc.sql.node.EolNode;
import org.seasar.doma.internal.jdbc.sql.node.ForBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.GroupByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.HavingClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.IfBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.LogicalOperatorNode;
import org.seasar.doma.internal.jdbc.sql.node.OrderByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.OtherNode;
import org.seasar.doma.internal.jdbc.sql.node.ParensNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.WhitespaceNode;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlParser {
    protected static final Pattern LITERAL_PATTERN = Pattern.compile("[-+'.0-9]|.*'|true|false|null", 2);
    protected final Deque<SqlNode> nodeStack = new LinkedList<SqlNode>();
    protected final String sql;
    protected final SqlTokenizer tokenizer;
    protected final AnonymousNode rootNode;
    protected SqlTokenType tokenType;
    protected String token;

    public SqlParser(String sql) {
        AssertionUtil.assertNotNull(sql);
        this.sql = sql;
        this.tokenizer = new SqlTokenizer(sql);
        this.rootNode = new AnonymousNode();
        this.nodeStack.push(this.rootNode);
    }

    public SqlNode parse() {
        block28: while (true) {
            this.tokenType = this.tokenizer.next();
            this.token = this.tokenizer.getToken();
            switch (this.tokenType) {
                case WHITESPACE: {
                    this.parseWhitespace();
                    continue block28;
                }
                case WORD: 
                case QUOTE: {
                    this.parseWord();
                    continue block28;
                }
                case SELECT_WORD: {
                    this.parseSelectWord();
                    continue block28;
                }
                case FROM_WORD: {
                    this.parseFromWord();
                    continue block28;
                }
                case WHERE_WORD: {
                    this.parseWhereWord();
                    continue block28;
                }
                case GROUP_BY_WORD: {
                    this.parseGroupByWord();
                    continue block28;
                }
                case HAVING_WORD: {
                    this.parseHavingWord();
                    continue block28;
                }
                case ORDER_BY_WORD: {
                    this.parseOrderByWord();
                    continue block28;
                }
                case FOR_UPDATE_WORD: {
                    this.parseForUpdateWord();
                    continue block28;
                }
                case AND_WORD: 
                case OR_WORD: {
                    this.parseLogicalWord();
                    continue block28;
                }
                case OPENED_PARENS: {
                    this.parseOpenedParens();
                    continue block28;
                }
                case CLOSED_PARENS: {
                    this.parseClosedParens();
                    continue block28;
                }
                case BIND_VARIABLE_BLOCK_COMMENT: {
                    this.parseBindVariableBlockComment();
                    continue block28;
                }
                case EMBEDDED_VARIABLE_BLOCK_COMMENT: {
                    this.parseEmbeddedVariableBlockComment();
                    continue block28;
                }
                case IF_BLOCK_COMMENT: {
                    this.parseIfBlockComment();
                    continue block28;
                }
                case ELSEIF_BLOCK_COMMENT: {
                    this.parseElseifBlockComment();
                    continue block28;
                }
                case ELSEIF_LINE_COMMENT: {
                    this.parseElseifLineComment();
                    continue block28;
                }
                case ELSE_BLOCK_COMMENT: {
                    this.parseElseBlockComment();
                    continue block28;
                }
                case ELSE_LINE_COMMENT: {
                    this.parseElseLineComment();
                    continue block28;
                }
                case END_BLOCK_COMMENT: {
                    this.parseEndBlockComment();
                    continue block28;
                }
                case FOR_BLOCK_COMMENT: {
                    this.parseForBlockComment();
                    continue block28;
                }
                case UNION_WORD: 
                case EXCEPT_WORD: 
                case MINUS_WORD: 
                case INTERSECT_WORD: {
                    this.parseSetOperatorWord();
                    continue block28;
                }
                case BLOCK_COMMENT: 
                case LINE_COMMENT: {
                    this.parseComment();
                    continue block28;
                }
                case OTHER: {
                    this.parseOther();
                    continue block28;
                }
                case EOL: {
                    this.parseEOL();
                    continue block28;
                }
                case DELIMITER: 
                case EOF: {
                    break block28;
                }
                default: {
                    AssertionUtil.assertUnreachable();
                    continue block28;
                }
            }
            break;
        }
        this.validate();
        this.validateParensClosed();
        return this.rootNode;
    }

    protected void parseSetOperatorWord() {
        this.validate();
        AnonymousNode node = new AnonymousNode();
        node.addNode(new WordNode(this.token));
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            this.pop();
        }
        this.addNode(node);
        this.push(node);
    }

    protected void parseSelectWord() {
        this.validate();
        SelectStatementNode selectStatementNode = new SelectStatementNode();
        this.addNode(selectStatementNode);
        this.push(selectStatementNode);
        SelectClauseNode selectClauseNode = new SelectClauseNode(this.token);
        selectStatementNode.setSelectClauseNode(selectClauseNode);
        this.push(selectClauseNode);
    }

    protected void parseFromWord() {
        this.validate();
        FromClauseNode node = new FromClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setFromClauseNode(node);
        } else {
            this.addNode(node);
        }
        this.push(node);
    }

    protected void parseWhereWord() {
        this.validate();
        WhereClauseNode node = new WhereClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setWhereClauseNode(node);
        } else {
            this.addNode(node);
        }
        this.push(node);
    }

    protected void parseGroupByWord() {
        this.validate();
        GroupByClauseNode node = new GroupByClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setGroupByClauseNode(node);
        } else {
            this.addNode(node);
        }
        this.push(node);
    }

    protected void parseHavingWord() {
        this.validate();
        HavingClauseNode node = new HavingClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setHavingClauseNode(node);
        } else {
            this.addNode(node);
        }
        this.push(node);
    }

    protected void parseOrderByWord() {
        this.validate();
        OrderByClauseNode node = new OrderByClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setOrderByClauseNode(node);
        } else {
            this.addNode(node);
        }
        this.push(node);
    }

    protected void parseForUpdateWord() {
        this.validate();
        ForUpdateClauseNode node = new ForUpdateClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setForUpdateClauseNode(node);
        } else {
            this.addNode(node);
        }
        this.push(node);
    }

    protected void parseLogicalWord() {
        String word = this.tokenType.extract(this.token);
        LogicalOperatorNode node = new LogicalOperatorNode(word);
        this.addNode(node);
        this.push(node);
    }

    protected void parseWord() {
        WordNode node = new WordNode(this.token);
        this.addNode(node);
    }

    protected void parseComment() {
        CommentNode node = new CommentNode(this.token);
        this.addNode(node);
    }

    protected void parseOpenedParens() {
        ParensNode parensNode = new ParensNode(this.getLocation());
        this.addNode(parensNode);
        this.push(parensNode);
    }

    protected void parseClosedParens() {
        if (!this.isInParensNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2109, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.validate();
        this.removeNodesTo(ParensNode.class);
        ParensNode parensNode = (ParensNode)this.pop();
        for (SqlNode child : parensNode.getChildren()) {
            if (child instanceof WhitespaceNode || child instanceof CommentNode) continue;
            parensNode.setEmpty(false);
            break;
        }
        parensNode.close();
    }

    protected void parseBindVariableBlockComment() {
        String varialbeName = this.tokenType.extract(this.token);
        if (varialbeName.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2120, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), this.token);
        }
        BindVariableNode node = new BindVariableNode(this.getLocation(), varialbeName, this.token);
        this.addNode(node);
        this.push(node);
    }

    protected void parseEmbeddedVariableBlockComment() {
        String varialbeName = this.tokenType.extract(this.token);
        if (varialbeName.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2121, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), this.token);
        }
        EmbeddedVariableNode node = new EmbeddedVariableNode(this.getLocation(), varialbeName, this.token);
        this.addNode(node);
        this.push(node);
    }

    protected void parseIfBlockComment() {
        IfBlockNode ifBlockNode = new IfBlockNode();
        this.addNode(ifBlockNode);
        this.push(ifBlockNode);
        String expression = this.tokenType.extract(this.token);
        IfNode ifNode = new IfNode(this.getLocation(), expression, this.token);
        ifBlockNode.setIfNode(ifNode);
        this.push(ifNode);
    }

    protected void parseElseifBlockComment() {
        if (!this.isInIfBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2138, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(IfBlockNode.class);
        IfBlockNode ifBlockNode = (IfBlockNode)this.peek();
        if (ifBlockNode.isElseNodeExistent()) {
            throw new JdbcException((MessageResource)Message.DOMA2139, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String expression = this.tokenType.extract(this.token);
        ElseifNode node = new ElseifNode(this.getLocation(), expression, this.token);
        ifBlockNode.addElseifNode(node);
        this.push(node);
    }

    protected void parseElseifLineComment() {
        if (!this.isInIfBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2106, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(IfBlockNode.class);
        IfBlockNode ifBlockNode = (IfBlockNode)this.peek();
        if (ifBlockNode.isElseNodeExistent()) {
            throw new JdbcException((MessageResource)Message.DOMA2108, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String expression = this.tokenType.extract(this.token);
        ElseifNode node = new ElseifNode(this.getLocation(), expression, this.token);
        ifBlockNode.addElseifNode(node);
        this.push(node);
    }

    protected void parseElseBlockComment() {
        if (!this.isInIfBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2140, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(IfBlockNode.class);
        IfBlockNode ifBlockNode = (IfBlockNode)this.peek();
        if (ifBlockNode.isElseNodeExistent()) {
            throw new JdbcException((MessageResource)Message.DOMA2141, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        ElseNode node = new ElseNode(this.token);
        ifBlockNode.setElseNode(node);
        this.push(node);
    }

    protected void parseElseLineComment() {
        if (!this.isInIfBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2105, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(IfBlockNode.class);
        IfBlockNode ifBlockNode = (IfBlockNode)this.peek();
        if (ifBlockNode.isElseNodeExistent()) {
            throw new JdbcException((MessageResource)Message.DOMA2107, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        ElseNode node = new ElseNode(this.token);
        ifBlockNode.setElseNode(node);
        this.push(node);
    }

    protected void parseEndBlockComment() {
        if (!this.isInBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2104, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(BlockNode.class);
        BlockNode blockNode = (BlockNode)this.pop();
        EndNode node = new EndNode(this.token);
        blockNode.setEndNode(node);
        this.push(node);
    }

    protected void parseForBlockComment() {
        ForBlockNode forBlockNode = new ForBlockNode();
        this.addNode(forBlockNode);
        this.push(forBlockNode);
        String expr = this.tokenType.extract(this.token);
        int pos = expr.indexOf(":");
        if (pos == -1) {
            throw new JdbcException((MessageResource)Message.DOMA2124, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String identifier = expr.substring(0, pos).trim();
        if (identifier.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2125, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String expression = expr.substring(pos + 1).trim();
        if (expression.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2126, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        ForNode forNode = new ForNode(this.getLocation(), identifier, expression, this.token);
        forBlockNode.setForNode(forNode);
        this.push(forNode);
    }

    protected void parseOther() {
        this.addNode(OtherNode.of(this.token));
    }

    protected void parseEOL() {
        EolNode node = new EolNode(this.token);
        this.addNode(node);
    }

    protected boolean containsOnlyWhitespaces(SqlNode node) {
        for (SqlNode child : node.getChildren()) {
            if (child instanceof WhitespaceNode) continue;
            return false;
        }
        return true;
    }

    protected void parseWhitespace() {
        this.addNode(WhitespaceNode.of(this.token));
    }

    protected void removeNodesTo(Class<? extends SqlNode> clazz) {
        SqlNode node;
        Iterator<SqlNode> it = this.nodeStack.iterator();
        while (it.hasNext() && !clazz.isInstance(node = it.next())) {
            it.remove();
        }
    }

    protected boolean isInSelectStatementNode() {
        for (SqlNode node : this.nodeStack) {
            if (node instanceof ParensNode) {
                return false;
            }
            if (!(node instanceof SelectStatementNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInIfBlockNode() {
        for (SqlNode node : this.nodeStack) {
            if (node instanceof ParensNode) {
                return false;
            }
            if (!(node instanceof IfBlockNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInForBlockNode() {
        for (SqlNode node : this.nodeStack) {
            if (node instanceof ParensNode) {
                return false;
            }
            if (!(node instanceof ForBlockNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInParensNode() {
        for (SqlNode node : this.nodeStack) {
            if (!(node instanceof ParensNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInBlockNode() {
        for (SqlNode node : this.nodeStack) {
            if (node instanceof ParensNode) {
                return false;
            }
            if (!(node instanceof BlockNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAfterBindVariableNode() {
        return this.peek() instanceof BindVariableNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addNode(SqlNode node) {
        if (this.isAfterBindVariableNode()) {
            BindVariableNode bindVariableNode = (BindVariableNode)this.pop();
            if (node instanceof WordNode) {
                WordNode wordNode = (WordNode)node;
                String word = wordNode.getWord();
                Matcher matcher = LITERAL_PATTERN.matcher(word);
                if (!matcher.lookingAt()) throw new JdbcException((MessageResource)Message.DOMA2142, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), bindVariableNode.getText(), word);
                bindVariableNode.setWordNode(wordNode);
                return;
            } else {
                if (!(node instanceof ParensNode)) throw new JdbcException((MessageResource)Message.DOMA2110, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), bindVariableNode.getText());
                ParensNode parensNode = (ParensNode)node;
                parensNode.setAttachedWithBindVariable(true);
                bindVariableNode.setParensNode(parensNode);
            }
            return;
        } else {
            this.peek().addNode(node);
        }
    }

    protected void push(SqlNode node) {
        this.nodeStack.push(node);
    }

    protected <T extends SqlNode> T peek() {
        return (T)this.nodeStack.peek();
    }

    protected <T extends SqlNode> T pop() {
        return (T)this.nodeStack.pop();
    }

    protected SqlLocation getLocation() {
        return new SqlLocation(this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
    }

    protected void validate() {
        if (this.isAfterBindVariableNode()) {
            BindVariableNode bindVariableNode = (BindVariableNode)this.pop();
            throw new JdbcException((MessageResource)Message.DOMA2110, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), bindVariableNode.getText());
        }
        if (this.isInIfBlockNode()) {
            this.removeNodesTo(IfBlockNode.class);
            IfBlockNode ifBlockNode = (IfBlockNode)this.pop();
            SqlLocation location = ifBlockNode.getIfNode().getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2133, this.sql, location.getLineNumber(), location.getPosition());
        }
        if (this.isInForBlockNode()) {
            this.removeNodesTo(ForBlockNode.class);
            ForBlockNode forBlockNode = (ForBlockNode)this.pop();
            SqlLocation location = forBlockNode.getForNode().getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2134, this.sql, location.getLineNumber(), location.getPosition());
        }
    }

    protected void validateParensClosed() {
        if (this.isInParensNode()) {
            this.removeNodesTo(ParensNode.class);
            ParensNode parensNode = (ParensNode)this.pop();
            SqlLocation location = parensNode.getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2135, this.sql, location.getLineNumber(), location.getPosition());
        }
    }
}

