/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.ShortWrapperVisitor;
import org.seasar.doma.wrapper.WrapperVisitor;

public class ShortWrapper
extends AbstractWrapper<Short>
implements NumberWrapper<Short> {
    public ShortWrapper() {
    }

    public ShortWrapper(Short value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        super.set(v.shortValue());
    }

    @Override
    public Short getDefault() {
        return (short)0;
    }

    @Override
    public void increment() {
        Short value = this.getIncrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public void decrement() {
        Short value = this.getDecrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public Short getIncrementedValue() {
        Short value = (Short)this.doGet();
        if (value != null) {
            return (short)(value + 1);
        }
        return null;
    }

    @Override
    public Short getDecrementedValue() {
        Short value = (Short)this.doGet();
        if (value != null) {
            return (short)(value - 1);
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof ShortWrapperVisitor) {
            ShortWrapperVisitor v = (ShortWrapperVisitor)visitor;
            return v.visitShortWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

