/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.mirror.DeleteMirror;
import org.seasar.doma.internal.apt.mirror.InsertMirror;
import org.seasar.doma.internal.apt.mirror.ModifyMirror;
import org.seasar.doma.internal.apt.mirror.UpdateMirror;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoModifyQueryMetaFactory
extends AbstractQueryMetaFactory<AutoModifyQueryMeta> {
    public AutoModifyQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        AutoModifyQueryMeta queryMeta = this.createAutoModifyQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    protected AutoModifyQueryMeta createAutoModifyQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AutoModifyQueryMeta queryMeta = new AutoModifyQueryMeta(method);
        ModifyMirror modifyMirror = InsertMirror.newInstance(method, this.env);
        if (modifyMirror != null && !modifyMirror.getSqlFileValue()) {
            queryMeta.setModifyMirror(modifyMirror);
            queryMeta.setQueryKind(QueryKind.AUTO_INSERT);
            return queryMeta;
        }
        modifyMirror = UpdateMirror.newInstance(method, this.env);
        if (modifyMirror != null && !modifyMirror.getSqlFileValue()) {
            queryMeta.setModifyMirror(modifyMirror);
            queryMeta.setQueryKind(QueryKind.AUTO_UPDATE);
            return queryMeta;
        }
        modifyMirror = DeleteMirror.newInstance(method, this.env);
        if (modifyMirror != null && !modifyMirror.getSqlFileValue()) {
            queryMeta.setModifyMirror(modifyMirror);
            queryMeta.setQueryKind(QueryKind.AUTO_DELETE);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(AutoModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(method);
        EntityType entityType = queryMeta.getEntityType();
        if (entityType != null && entityType.isImmutable()) {
            if (!returnMeta.isResult(entityType)) {
                throw new AptException((MessageResource)Message.DOMA4222, this.env, (Element)returnMeta.getElement(), new Object[0]);
            }
        } else if (!returnMeta.isPrimitiveInt()) {
            throw new AptException((MessageResource)Message.DOMA4001, this.env, (Element)returnMeta.getElement(), new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(AutoModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        List<? extends VariableElement> parameters = method.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.env, (Element)method, new Object[0]);
        }
        final QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        EntityType entityType = parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<EntityType, Void, RuntimeException>(){

            @Override
            protected EntityType defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4003, AutoModifyQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), new Object[0]);
            }

            @Override
            public EntityType visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                return dataType;
            }
        }, null);
        queryMeta.setEntityType(entityType);
        queryMeta.setEntityParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterType(parameterMeta.getName(), entityType.getTypeMirror());
        }
        ModifyMirror modifyMirror = queryMeta.getModifyMirror();
        this.validateEntityPropertyNames(entityType.getTypeMirror(), method, modifyMirror.getAnnotationMirror(), modifyMirror.getInclude(), modifyMirror.getExclude());
    }
}

