/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import org.seasar.extension.jdbc.SqlFileFunctionCall;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractFunctionCall;
import org.seasar.extension.sql.Node;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.cache.NodeCache;
import org.seasar.extension.sql.context.SqlContextImpl;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileFunctionCallImpl<T>
extends AbstractFunctionCall<T, SqlFileFunctionCall<T>>
implements SqlFileFunctionCall<T> {
    protected String path;
    protected Node node;

    public SqlFileFunctionCallImpl(JdbcManagerImplementor jdbcManager, Class<T> resultClass, String path) {
        this(jdbcManager, resultClass, path, null);
    }

    public SqlFileFunctionCallImpl(JdbcManagerImplementor jdbcManager, Class<T> resultClass, String path, Object param) {
        super(jdbcManager, resultClass);
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.parameter = param;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareNode();
        this.prepareSql();
        this.prepareReturnParameter();
        this.prepareParameter();
    }

    protected void prepareNode() throws ResourceNotFoundRuntimeException {
        this.node = NodeCache.getNode(this.path, this.jdbcManager.getDialect().getName());
        if (this.node == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new ResourceNotFoundRuntimeException(this.path);
        }
    }

    protected void prepareSql() {
        SqlContextImpl sqlContext = new SqlContextImpl();
        this.node.accept((SqlContext)sqlContext);
        this.executedSql = sqlContext.getSql();
    }
}

