/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.io.Serializable;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.SelectForUpdateType;

public class SelectOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long offset = -1L;
    protected long limit = -1L;
    protected boolean count;
    protected long countSize = -1L;
    protected SelectForUpdateType forUpdateType;
    protected int waitSeconds;
    protected String[] aliases = new String[0];

    protected SelectOptions() {
    }

    public static SelectOptions get() {
        return new SelectOptions();
    }

    public SelectOptions forUpdate() {
        this.forUpdateType = SelectForUpdateType.NORMAL;
        return this;
    }

    public SelectOptions forUpdate(String ... aliases) {
        if (aliases == null) {
            new DomaNullPointerException("aliases");
        }
        this.forUpdateType = SelectForUpdateType.NORMAL;
        this.aliases = aliases;
        return this;
    }

    public SelectOptions forUpdateNowait() {
        this.forUpdateType = SelectForUpdateType.NOWAIT;
        return this;
    }

    public SelectOptions forUpdateNowait(String ... aliases) {
        if (aliases == null) {
            new DomaNullPointerException("aliases");
        }
        this.forUpdateType = SelectForUpdateType.NOWAIT;
        this.aliases = aliases;
        return this;
    }

    public SelectOptions forUpdateWait(int waitSeconds) {
        if (waitSeconds < 0) {
            new DomaIllegalArgumentException("waitSeconds", "waitSeconds < 0");
        }
        this.forUpdateType = SelectForUpdateType.WAIT;
        this.waitSeconds = waitSeconds;
        return this;
    }

    public SelectOptions forUpdateWait(int waitSeconds, String ... aliases) {
        if (waitSeconds < 0) {
            new DomaIllegalArgumentException("waitSeconds", "waitSeconds < 0");
        }
        if (aliases == null) {
            new DomaNullPointerException("aliases");
        }
        this.forUpdateType = SelectForUpdateType.WAIT;
        this.waitSeconds = waitSeconds;
        this.aliases = aliases;
        return this;
    }

    public SelectOptions offset(int offset) {
        if (offset < 0) {
            new DomaIllegalArgumentException("offset", "offset < 0");
        }
        this.offset = offset;
        return this;
    }

    public SelectOptions limit(int limit) {
        if (limit < 0) {
            new DomaIllegalArgumentException("limit", "limit < 0");
        }
        this.limit = limit;
        return this;
    }

    public SelectOptions count() {
        this.count = true;
        return this;
    }

    public long getCount() {
        return this.countSize;
    }
}

