/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.lang.reflect.Field;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.FieldUtil;
import org.seasar.doma.jdbc.entity.OriginalStatesAccessException;
import org.seasar.doma.jdbc.entity.OriginalStatesNotFoundException;

public class OriginalStatesAccessor<E> {
    protected final Class<? super E> entityClass;
    protected final String name;
    protected final Field field;

    public OriginalStatesAccessor(Class<? super E> entityClass, String name) {
        if (entityClass == null) {
            throw new DomaNullPointerException("entityClass");
        }
        if (name == null) {
            throw new DomaNullPointerException("name");
        }
        this.entityClass = entityClass;
        this.name = name;
        this.field = this.getField();
    }

    private Field getField() {
        Field field;
        try {
            field = ClassUtil.getDeclaredField(this.entityClass, this.name);
        }
        catch (WrapException wrapException) {
            throw new OriginalStatesNotFoundException(wrapException.getCause(), this.entityClass.getName(), this.name);
        }
        if (!FieldUtil.isPublic(field)) {
            try {
                FieldUtil.setAccessible(field, true);
            }
            catch (WrapException wrapException) {
                throw new OriginalStatesNotFoundException(wrapException.getCause(), this.entityClass.getName(), this.name);
            }
        }
        return field;
    }

    public E get(E entity) {
        if (entity == null) {
            throw new DomaNullPointerException("entity");
        }
        try {
            return (E)FieldUtil.get(this.field, entity);
        }
        catch (WrapException wrapException) {
            throw new OriginalStatesAccessException(wrapException.getCause(), this.entityClass.getName(), this.name);
        }
    }

    public void set(E entity, E states) {
        if (entity == null) {
            throw new DomaNullPointerException("entity");
        }
        try {
            FieldUtil.set(this.field, entity, states);
        }
        catch (WrapException wrapException) {
            throw new OriginalStatesAccessException(wrapException.getCause(), this.entityClass.getName(), this.name);
        }
    }
}

