/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.sql.DataSource;
import org.seasar.doma.AnnotationTarget;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.meta.AbstractCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.ArrayCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoModuleQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoProcedureQueryMeta;
import org.seasar.doma.internal.apt.meta.BasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicResultParameterMeta;
import org.seasar.doma.internal.apt.meta.CallableSqlParameterMeta;
import org.seasar.doma.internal.apt.meta.CallableSqlParameterMetaVisitor;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DelegateQueryMeta;
import org.seasar.doma.internal.apt.meta.DomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainResultParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityListParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.MapListParameterMeta;
import org.seasar.doma.internal.apt.meta.MapListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryMetaVisitor;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlFileModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlFileScriptQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlFileSelectQueryMeta;
import org.seasar.doma.internal.apt.mirror.AnnotationMirror;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.EnumWrapperType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.IterationCallbackType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.apt.type.WrapperType;
import org.seasar.doma.internal.jdbc.command.BasicIterationHandler;
import org.seasar.doma.internal.jdbc.command.BasicResultListHandler;
import org.seasar.doma.internal.jdbc.command.BasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.DomainIterationHandler;
import org.seasar.doma.internal.jdbc.command.DomainResultListHandler;
import org.seasar.doma.internal.jdbc.command.DomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.EntityIterationHandler;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.MapIterationHandler;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.internal.jdbc.command.MapSingleResultHandler;
import org.seasar.doma.internal.jdbc.dao.AbstractDao;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListResultParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainResultParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListResultParameter;
import org.seasar.doma.internal.jdbc.sql.MapListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListResultParameter;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;

public class DaoGenerator
extends AbstractGenerator {
    protected final DaoMeta daoMeta;

    public DaoGenerator(ProcessingEnvironment env, TypeElement daoElement, DaoMeta daoMeta) throws IOException {
        super(env, daoElement, Options.getDaoPackage(env), Options.getDaoSubpackage(env), "", Options.getDaoSuffix(env));
        AssertionUtil.assertNotNull(daoMeta);
        this.daoMeta = daoMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        this.iprint("/** */%n", new Object[0]);
        for (AnnotationMirror annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CLASS)) {
            this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.printGenerated();
        String parentClassName = AbstractDao.class.getName();
        ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
        if (parentDaoMeta != null) {
            TypeElement parentDaotElement = parentDaoMeta.getDaoElement();
            parentClassName = this.createQualifiedName(this.env, parentDaotElement, this.fullpackage, this.subpackage, this.prefix, this.suffix);
        }
        this.iprint("public class %1$s extends %2$s implements %3$s {%n", this.simpleName, parentClassName, this.daoMeta.getDaoType());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printStaticFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.print("}%n", new Object[0]);
    }

    protected void printStaticFields() {
        int i = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            if (queryMeta.getQueryKind().isTrigger()) {
                this.iprint("private static final %1$s __method%2$s = %3$s.__getDeclaredMethod(%4$s.class, \"%5$s\"", Method.class.getName(), i, AbstractDao.class.getName(), this.daoMeta.getDaoType(), queryMeta.getName());
                for (QueryParameterMeta parameterMeta : queryMeta.getParameterMetas()) {
                    this.print(", %1$s.class", parameterMeta.getQualifiedName());
                }
                this.print(");%n", new Object[0]);
                this.print("%n", new Object[0]);
            }
            ++i;
        }
    }

    protected void printConstructors() {
        if (this.daoMeta.hasUserDefinedConfig()) {
            this.iprint("/** */%n", new Object[0]);
            this.iprint("public %1$s() {%n", this.simpleName);
            this.indent();
            this.iprint("super(new %1$s());%n", this.daoMeta.getConfigType());
            this.unindent();
            this.iprint("}%n", new Object[0]);
            this.print("%n", new Object[0]);
            if (this.daoMeta.getAnnotateWithMirror() == null) {
                boolean jdbcConstructorsNecessary;
                ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
                boolean bl = jdbcConstructorsNecessary = parentDaoMeta == null || parentDaoMeta.hasUserDefinedConfig();
                if (jdbcConstructorsNecessary) {
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param connection the connection%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("public %1$s(%2$s connection) {%n", this.simpleName, Connection.class.getName());
                    this.indent();
                    this.iprint("super(new %1$s(), connection);%n", this.daoMeta.getConfigType());
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param dataSource the dataSource%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("public %1$s(%2$s dataSource) {%n", this.simpleName, DataSource.class.getName());
                    this.indent();
                    this.iprint("super(new %1$s(), dataSource);%n", this.daoMeta.getConfigType());
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                }
                this.iprint("/**%n", new Object[0]);
                this.iprint(" * @param config the configuration%n", new Object[0]);
                this.iprint(" */%n", new Object[0]);
                this.iprint("protected %1$s(%2$s config) {%n", this.simpleName, Config.class.getName());
                this.indent();
                this.iprint("super(config);%n", this.daoMeta.getConfigType());
                this.unindent();
                this.iprint("}%n", new Object[0]);
                this.print("%n", new Object[0]);
                if (jdbcConstructorsNecessary) {
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param config the configuration%n", new Object[0]);
                    this.iprint(" * @param connection the connection%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("protected %1$s(%2$s config, %3$s connection) {%n", this.simpleName, Config.class.getName(), Connection.class.getName());
                    this.indent();
                    this.iprint("super(config, connection);%n", this.daoMeta.getConfigType());
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param config the configuration%n", new Object[0]);
                    this.iprint(" * @param dataSource the dataSource%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("protected %1$s(%2$s config, %3$s dataSource) {%n", this.simpleName, Config.class.getName(), DataSource.class.getName());
                    this.indent();
                    this.iprint("super(config, dataSource);%n", this.daoMeta.getConfigType());
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                }
            }
        }
        if (!this.daoMeta.hasUserDefinedConfig() || this.daoMeta.getAnnotateWithMirror() != null) {
            this.iprint("/**%n", new Object[0]);
            this.iprint(" * @param config the config%n", new Object[0]);
            this.iprint(" */%n", new Object[0]);
            for (AnnotationMirror annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR)) {
                this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
            }
            this.iprint("public %1$s(", this.simpleName);
            for (AnnotationMirror annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR_PARAMETER)) {
                this.print("@%1$s(%2$s) ", annotation.getTypeValue(), annotation.getElementsValue());
            }
            this.print("%1$s config) {%n", Config.class.getName());
            this.indent();
            this.iprint("super(config);%n", new Object[0]);
            this.unindent();
            this.iprint("}%n", new Object[0]);
            this.print("%n", new Object[0]);
        }
    }

    protected boolean isJdbcConstructoNecessary() {
        ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
        return parentDaoMeta == null || parentDaoMeta.hasUserDefinedConfig();
    }

    protected void printMethods() {
        MethodBodyGenerator generator = new MethodBodyGenerator();
        int i = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            this.printMethod(generator, queryMeta, i);
            ++i;
        }
    }

    protected void printMethod(MethodBodyGenerator generator, QueryMeta m, int index) {
        Iterator<Object> it;
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public ", new Object[0]);
        if (!m.getTypeParameterNames().isEmpty()) {
            this.print("<", new Object[0]);
            it = m.getTypeParameterNames().iterator();
            while (it.hasNext()) {
                this.print("%1$s", it.next());
                if (!it.hasNext()) continue;
                this.print(", ", new Object[0]);
            }
            this.print("> ", new Object[0]);
        }
        this.print("%1$s %2$s(", m.getReturnMeta().getTypeName(), m.getName());
        it = m.getParameterMetas().iterator();
        while (it.hasNext()) {
            QueryParameterMeta parameterMeta = (QueryParameterMeta)it.next();
            String parameterTypeName = parameterMeta.getTypeName();
            if (!it.hasNext() && m.isVarArgs()) {
                parameterTypeName = parameterTypeName.replace("[]", "...");
            }
            this.print("%1$s %2$s", parameterTypeName, parameterMeta.getName());
            if (!it.hasNext()) continue;
            this.print(", ", new Object[0]);
        }
        this.print(") ", new Object[0]);
        if (!m.getThrownTypeNames().isEmpty()) {
            this.print("throws ", new Object[0]);
            it = m.getThrownTypeNames().iterator();
            while (it.hasNext()) {
                this.print("%1$s", it.next());
                if (!it.hasNext()) continue;
                this.print(", ", new Object[0]);
            }
            this.print(" ", new Object[0]);
        }
        this.print("{%n", new Object[0]);
        this.indent();
        m.accept(generator, index);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    public String toCSVFormat(List<String> values) {
        StringBuilder buf = new StringBuilder();
        if (values.size() > 0) {
            for (String value : values) {
                buf.append("\"");
                buf.append(value);
                buf.append("\", ");
            }
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    protected class CallableSqlParameterStatementGenerator
    implements CallableSqlParameterMetaVisitor<Void, AutoModuleQueryMeta> {
        protected CallableSqlParameterStatementGenerator() {
        }

        @Override
        public Void visitBasicListParameterMeta(final BasicListParameterMeta m, AutoModuleQueryMeta p) {
            BasicType basicType = m.getBasicType();
            basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(new %3$s(%4$s.class), %5$s, \"%5$s\"));%n", BasicListParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(new %3$s(), %4$s, \"%4$s\"));%n", BasicListParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainListParameterMeta(DomainListParameterMeta m, AutoModuleQueryMeta p) {
            DomainType domainType = m.getDomainType();
            BasicType basicType = domainType.getBasicType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s, \"%5$s\"));%n", DomainListParameter.class.getName(), basicType.getTypeName(), domainType.getTypeName(), domainType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitEntityListParameterMeta(EntityListParameterMeta m, AutoModuleQueryMeta p) {
            EntityType entityType = m.getEntityType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s.getSingletonInternal(), %4$s, \"%4$s\", %5$s));%n", EntityListParameter.class.getName(), entityType.getTypeName(), entityType.getMetaTypeName(), m.getName(), m.getEnsureResultMapping());
            return null;
        }

        @Override
        public Void visitMapListParameterMeta(MapListParameterMeta m, AutoModuleQueryMeta p) {
            MapKeyNamingType namingType = p.getMapKeyNamingType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s.%3$s, %4$s, \"%4$s\"));%n", MapListParameter.class.getName(), namingType.getDeclaringClass().getName(), namingType.name(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicInOutParameterMeta(final BasicInOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicType basicType = m.getBasicType();
            basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(new %3$s(%4$s.class), %5$s));%n", BasicInOutParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(new %3$s(), %4$s));%n", BasicInOutParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainInOutParameterMeta(DomainInOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainType domainType = m.getDomainType();
            BasicType basicType = domainType.getBasicType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainInOutParameter.class.getName(), basicType.getTypeNameAsTypeParameter(), domainType.getTypeName(), domainType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicOutParameterMeta(final BasicOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicType basicType = m.getBasicType();
            basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(new %3$s(%4$s.class), %5$s));%n", BasicOutParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(new %3$s(), %4$s));%n", BasicOutParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainOutParameterMeta(DomainOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainType domainType = m.getDomainType();
            BasicType basicType = domainType.getBasicType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainOutParameter.class.getName(), basicType.getTypeName(), domainType.getTypeName(), domainType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicInParameterMeta(final BasicInParameterMeta m, AutoModuleQueryMeta p) {
            BasicType basicType = m.getBasicType();
            basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s(new %2$s(%3$s.class, %4$s)));%n", BasicInParameter.class.getName(), dataType.getTypeName(), dataType.getWrappedType().getTypeName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s(new %2$s(%3$s)));%n", BasicInParameter.class.getName(), dataType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainInParameterMeta(DomainInParameterMeta m, AutoModuleQueryMeta p) {
            DomainType domainType = m.getDomainType();
            BasicType basicType = domainType.getBasicType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainInParameter.class.getName(), basicType.getTypeName(), domainType.getTypeName(), domainType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicListResultParameterMeta(BasicListResultParameterMeta m, AutoModuleQueryMeta p) {
            BasicType basicType = m.getBasicType();
            basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(new %3$s(%4$s.class)));%n", BasicListResultParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(new %3$s()));%n", BasicListResultParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainListResultParameterMeta(DomainListResultParameterMeta m, AutoModuleQueryMeta p) {
            DomainType domainType = m.getDomainType();
            BasicType basicType = domainType.getBasicType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", DomainListResultParameter.class.getName(), basicType.getTypeName(), domainType.getTypeName(), domainType.getInstantiationCommand());
            return null;
        }

        @Override
        public Void visitEntityListResultParameterMeta(EntityListResultParameterMeta m, AutoModuleQueryMeta p) {
            EntityType entityType = m.getEntityType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s.getSingletonInternal(), %4$s));%n", EntityListResultParameter.class.getName(), entityType.getTypeName(), entityType.getMetaTypeName(), m.getEnsureResultMapping());
            return null;
        }

        @Override
        public Void visitMapListResultParameterMeta(MapListResultParameterMeta m, AutoModuleQueryMeta p) {
            MapKeyNamingType namingType = p.getMapKeyNamingType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s(%2$s.%3$s));%n", MapListResultParameter.class.getName(), namingType.getDeclaringClass().getName(), namingType.name());
            return null;
        }

        @Override
        public Void visitBasicResultParameterMeta(BasicResultParameterMeta m, AutoModuleQueryMeta p) {
            final BasicType basicType = m.getBasicType();
            basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(new %3$s(%4$s.class), false));%n", BasicResultParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(new %3$s(), %4$s));%n", BasicResultParameter.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), basicType.isPrimitive());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainResultParameterMeta(DomainResultParameterMeta m, AutoModuleQueryMeta p) {
            DomainType domainType = m.getDomainType();
            BasicType basicType = domainType.getBasicType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", DomainResultParameter.class.getName(), basicType.getTypeName(), domainType.getTypeName(), domainType.getInstantiationCommand());
            return null;
        }
    }

    protected class MethodBodyGenerator
    implements QueryMetaVisitor<Void, Integer> {
        protected MethodBodyGenerator() {
        }

        @Override
        public Void visitSqlFileSelectQueryMeta(final SqlFileSelectQueryMeta m, Integer p) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = new %1$s();%n", m.getQueryClass().getName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            if (m.getSelectOptionsType() != null) {
                DaoGenerator.this.iprint("__query.setOptions(%1$s);%n", m.getSelectOptionsParameterName());
            }
            for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
                if (!parameterMeta.isBindable()) continue;
                DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s);%n", parameterMeta.getName(), parameterMeta.getQualifiedName());
            }
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setResultEnsured(%1$s);%n", m.getEnsureResult());
            DaoGenerator.this.iprint("__query.setResultMappingEnsured(%1$s);%n", m.getEnsureResultMapping());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setMaxRows(%1$s);%n", m.getMaxRows());
            DaoGenerator.this.iprint("__query.setFetchSize(%1$s);%n", m.getFetchSize());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            final QueryReturnMeta resultMeta = m.getReturnMeta();
            final String commandClassName = m.getCommandClass().getName();
            if (m.getIterate()) {
                IterationCallbackType callbackType = m.getIterationCallbackType();
                final String callbackParamName = m.getIterationCallbackPrameterName();
                callbackType.getTargetType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                    @Override
                    public Void visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                        dataType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                            @Override
                            public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s, %4$s>(new %5$s(%6$s.class), %7$s));%n", commandClassName, resultMeta.getTypeNameAsTypeParameter(), BasicIterationHandler.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName(), callbackParamName);
                                return null;
                            }

                            @Override
                            public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s, %4$s>(new %5$s(), %6$s));%n", commandClassName, resultMeta.getTypeNameAsTypeParameter(), BasicIterationHandler.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), callbackParamName);
                                return null;
                            }
                        }, null);
                        return null;
                    }

                    @Override
                    public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s, %4$s>(%5$s, %6$s));%n", commandClassName, resultMeta.getTypeNameAsTypeParameter(), DomainIterationHandler.class.getName(), dataType.getTypeNameAsTypeParameter(), dataType.getInstantiationCommand(), callbackParamName);
                        return null;
                    }

                    @Override
                    public Void visitMapType(MapType dataType, Void p) throws RuntimeException {
                        MapKeyNamingType namingType = m.getMapKeyNamingType();
                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s>(%4$s.%5$s, %6$s));%n", commandClassName, resultMeta.getTypeNameAsTypeParameter(), MapIterationHandler.class.getName(), namingType.getDeclaringClass().getName(), namingType.name(), callbackParamName);
                        return null;
                    }

                    @Override
                    public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s, %4$s>(%5$s.getSingletonInternal(), %6$s));%n", commandClassName, resultMeta.getTypeNameAsTypeParameter(), EntityIterationHandler.class.getName(), dataType.getTypeName(), dataType.getMetaTypeName(), callbackParamName);
                        return null;
                    }
                }, null);
                if ("void".equals(resultMeta.getTypeName())) {
                    DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
                    DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                    DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.qualifiedName, m.getName());
                } else {
                    DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
                    DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                    DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
                    DaoGenerator.this.iprint("return __result;%n", new Object[0]);
                }
            } else {
                m.getReturnMeta().getDataType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                    @Override
                    public Void visitBasicType(final BasicType basicType, Void p) throws RuntimeException {
                        basicType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                            @Override
                            public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s>(new %4$s(%5$s.class), false));%n", commandClassName, dataType.getWrappedType().getTypeNameAsTypeParameter(), BasicSingleResultHandler.class.getName(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName());
                                return null;
                            }

                            @Override
                            public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s>(new %4$s(), %5$s));%n", commandClassName, dataType.getWrappedType().getTypeNameAsTypeParameter(), BasicSingleResultHandler.class.getName(), dataType.getTypeName(), basicType.isPrimitive());
                                return null;
                            }
                        }, null);
                        return null;
                    }

                    @Override
                    public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s>(%4$s));%n", commandClassName, dataType.getTypeNameAsTypeParameter(), DomainSingleResultHandler.class.getName(), dataType.getInstantiationCommand());
                        return null;
                    }

                    @Override
                    public Void visitMapType(MapType dataType, Void p) throws RuntimeException {
                        MapKeyNamingType namingType = m.getMapKeyNamingType();
                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s(%4$s.%5$s));%n", commandClassName, dataType.getTypeNameAsTypeParameter(), MapSingleResultHandler.class.getName(), namingType.getDeclaringClass().getName(), namingType.name());
                        return null;
                    }

                    @Override
                    public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%2$s>(%4$s.getSingletonInternal()));%n", commandClassName, dataType.getTypeName(), EntitySingleResultHandler.class.getName(), dataType.getMetaTypeName());
                        return null;
                    }

                    @Override
                    public Void visitIterableType(final IterableType iterableType, Void p) throws RuntimeException {
                        iterableType.getElementType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                            @Override
                            public Void visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                                dataType.getWrapperType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                                    @Override
                                    public Void visitEnumWrapperType(EnumWrapperType dataType, Void p) throws RuntimeException {
                                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%4$s>(new %5$s(%6$s.class)));%n", commandClassName, iterableType.getTypeName(), BasicResultListHandler.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName(), dataType.getWrappedType().getQualifiedName());
                                        return null;
                                    }

                                    @Override
                                    public Void visitWrapperType(WrapperType dataType, Void p) throws RuntimeException {
                                        DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%4$s>(new %5$s()));%n", commandClassName, iterableType.getTypeNameAsTypeParameter(), BasicResultListHandler.class.getName(), dataType.getWrappedType().getTypeNameAsTypeParameter(), dataType.getTypeName());
                                        return null;
                                    }
                                }, null);
                                return null;
                            }

                            @Override
                            public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%4$s>(%5$s));%n", commandClassName, iterableType.getTypeName(), DomainResultListHandler.class.getName(), dataType.getTypeNameAsTypeParameter(), dataType.getInstantiationCommand());
                                return null;
                            }

                            @Override
                            public Void visitMapType(MapType dataType, Void p) throws RuntimeException {
                                MapKeyNamingType namingType = m.getMapKeyNamingType();
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s(%4$s.%5$s));%n", commandClassName, iterableType.getTypeName(), MapResultListHandler.class.getName(), namingType.getDeclaringClass().getName(), namingType.name());
                                return null;
                            }

                            @Override
                            public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                                DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query, new %3$s<%4$s>(%5$s.getSingletonInternal()));%n", commandClassName, iterableType.getTypeName(), EntityResultListHandler.class.getName(), dataType.getTypeName(), dataType.getMetaTypeName());
                                return null;
                            }
                        }, null);
                        return null;
                    }
                }, null);
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
                DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            }
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlFileScriptQueryMeta(SqlFileScriptQueryMeta m, Integer p) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = new %1$s();%n", m.getQueryClass().getName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setScriptFilePath(\"%1$s\");%n", ScriptFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setBlockDelimiter(\"%1$s\");%n", m.getBlockDelimiter());
            DaoGenerator.this.iprint("__query.setHaltOnError(%1$s);%n", m.getHaltOnError());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = new %1$s(__query);%n", m.getCommandClass().getName());
            DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.qualifiedName, m.getName());
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoModifyQueryMeta(AutoModifyQueryMeta m, Integer p) {
            Boolean suppressOptimisticLockException;
            Boolean includeUnchanged;
            List<String> exclude;
            List<String> include;
            Boolean ignoreVersion;
            Boolean includeVersion;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s<%2$s> __query = new %1$s<%2$s>(%3$s.getSingletonInternal());%n", m.getQueryClass().getName(), m.getEntityType().getTypeNameAsTypeParameter(), m.getEntityType().getMetaTypeNameAsTypeParameter());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setEntity(%1$s);%n", m.getEntityParameterName());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            Boolean excludeNull = m.getExcludeNull();
            if (excludeNull != null) {
                DaoGenerator.this.iprint("__query.setNullExcluded(%1$s);%n", excludeNull);
            }
            if ((includeVersion = m.getIncludeVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIncluded(%1$s);%n", includeVersion);
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((include = m.getInclude()) != null) {
                DaoGenerator.this.iprint("__query.setIncludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(include));
            }
            if ((exclude = m.getExclude()) != null) {
                DaoGenerator.this.iprint("__query.setExcludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(m.getExclude()));
            }
            if ((includeUnchanged = m.getIncludeUnchanged()) != null) {
                DaoGenerator.this.iprint("__query.setUnchangedPropertyIncluded(%1$s);%n", includeUnchanged);
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = new %1$s(__query);%n", m.getCommandClass().getName());
            EntityType entityType = m.getEntityType();
            if (entityType != null && entityType.isImmutable()) {
                DaoGenerator.this.iprint("int __count = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__count, __query.getEntity());%n", m.getReturnMeta().getTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlFileModifyQueryMeta(SqlFileModifyQueryMeta m, Integer p) {
            Boolean suppressOptimisticLockException;
            Boolean ignoreVersion;
            Boolean includeVersion;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = new %1$s();%n", m.getQueryClass().getName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
                if (!parameterMeta.isBindable()) continue;
                DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s);%n", parameterMeta.getName(), parameterMeta.getQualifiedName());
            }
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            if (m.getEntityParameterName() != null && m.getEntityType() != null) {
                DaoGenerator.this.iprint("__query.setEntityAndEntityType(\"%1$s\", %2$s, %3$s.getSingletonInternal());%n", m.getEntityParameterName(), m.getEntityParameterName(), m.getEntityType().getMetaTypeNameAsTypeParameter());
            }
            if ((includeVersion = m.getIncludeVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIncluded(%1$s);%n", includeVersion);
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = new %1$s(__query);%n", m.getCommandClass().getName());
            EntityType entityType = m.getEntityType();
            if (entityType != null && entityType.isImmutable()) {
                DaoGenerator.this.iprint("int __count = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__count, __query.getEntity(%2$s.class));%n", m.getReturnMeta().getTypeName(), entityType.getTypeNameAsTypeParameter());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoBatchModifyQueryMeta(AutoBatchModifyQueryMeta m, Integer p) {
            Boolean suppressOptimisticLockException;
            List<String> exclude;
            List<String> include;
            Boolean ignoreVersion;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s<%2$s> __query = new %1$s<%2$s>(%3$s.getSingletonInternal());%n", m.getQueryClass().getName(), m.getEntityType().getTypeNameAsTypeParameter(), m.getEntityType().getMetaTypeNameAsTypeParameter());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setEntities(%1$s);%n", m.getEntitiesParameterName());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setBatchSize(%1$s);%n", m.getBatchSize());
            Boolean includeVersion = m.getIncludeVersion();
            if (includeVersion != null) {
                DaoGenerator.this.iprint("__query.setVersionIncluded(%1$s);%n", includeVersion);
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((include = m.getInclude()) != null) {
                DaoGenerator.this.iprint("__query.setIncludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(include));
            }
            if ((exclude = m.getExclude()) != null) {
                DaoGenerator.this.iprint("__query.setExcludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(exclude));
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = new %1$s(__query);%n", m.getCommandClass().getName());
            EntityType entityType = m.getEntityType();
            if (entityType != null && entityType.isImmutable()) {
                DaoGenerator.this.iprint("int[] __counts = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__counts, __query.getEntities());%n", m.getReturnMeta().getTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlFileBatchModifyQueryMeta(SqlFileBatchModifyQueryMeta m, Integer p) {
            Boolean suppressOptimisticLockException;
            Boolean ignoreVersion;
            Boolean includeVersion;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s<%2$s> __query = new %1$s<%2$s>(%3$s.class);%n", m.getQueryClass().getName(), m.getElementType().getTypeNameAsTypeParameter(), m.getElementType().getQualifiedName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setElements(%1$s);%n", m.getElementsParameterName());
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            DaoGenerator.this.iprint("__query.setParameterName(\"%1$s\");%n", m.getElementsParameterName());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setBatchSize(%1$s);%n", m.getBatchSize());
            if (m.getEntityType() != null) {
                DaoGenerator.this.iprint("__query.setEntityType(%1$s.getSingletonInternal());%n", m.getEntityType().getMetaTypeNameAsTypeParameter());
            }
            if ((includeVersion = m.getIncludeVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIncluded(%1$s);%n", includeVersion);
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = new %1$s(__query);%n", m.getCommandClass().getName());
            EntityType entityType = m.getEntityType();
            if (entityType != null && entityType.isImmutable()) {
                DaoGenerator.this.iprint("int[] __counts = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__counts, __query.getEntities());%n", m.getReturnMeta().getTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoFunctionQueryMeta(AutoFunctionQueryMeta m, Integer p) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            QueryReturnMeta resultMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s<%2$s> __query = new %1$s<%2$s>();%n", m.getQueryClass().getName(), resultMeta.getTypeNameAsTypeParameter());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setFunctionName(\"%1$s\");%n", m.getFunctionName());
            CallableSqlParameterStatementGenerator parameterGenerator = new CallableSqlParameterStatementGenerator();
            m.getResultParameterMeta().accept(parameterGenerator, m);
            for (CallableSqlParameterMeta parameterMeta : m.getCallableSqlParameterMetas()) {
                parameterMeta.accept(parameterGenerator, m);
            }
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query);%n", m.getCommandClass().getName(), resultMeta.getTypeNameAsTypeParameter());
            DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoProcedureQueryMeta(AutoProcedureQueryMeta m, Integer p) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = new %1$s();%n", m.getQueryClass().getName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setProcedureName(\"%1$s\");%n", m.getProcedureName());
            CallableSqlParameterStatementGenerator parameterGenerator = new CallableSqlParameterStatementGenerator();
            for (CallableSqlParameterMeta parameterMeta : m.getCallableSqlParameterMetas()) {
                parameterMeta.accept(parameterGenerator, m);
            }
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = new %1$s(__query);%n", m.getCommandClass().getName());
            DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.qualifiedName, m.getName());
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAbstractCreateQueryMeta(AbstractCreateQueryMeta m, Integer p) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            QueryReturnMeta resultMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s __query = new %1$s();%n", m.getQueryClass().getName(), resultMeta.getTypeName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query);%n", m.getCommandClass().getName(), resultMeta.getTypeName());
            DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitArrayCreateQueryMeta(ArrayCreateQueryMeta m, Integer p) {
            this.printArrayCreateEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            QueryReturnMeta resultMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s __query = new %1$s();%n", m.getQueryClass().getName());
            if (m.isTrigger()) {
                DaoGenerator.this.iprint("__query.setMethod(__method%1$s);%n", p);
            }
            DaoGenerator.this.iprint("__query.setConfig(config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.qualifiedName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setTypeName(\"%1$s\");%n", m.getArrayTypeName());
            DaoGenerator.this.iprint("__query.setElements(%1$s);%n", m.getParameterName());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s<%2$s> __command = new %1$s<%2$s>(__query);%n", m.getCommandClass().getName(), resultMeta.getTypeNameAsTypeParameter());
            DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitDelegateQueryMeta(DelegateQueryMeta m, Integer p) {
            this.printEnteringStatements(m);
            DaoGenerator.this.iprint("%1$s __delegate = new %1$s(config", m.getTo());
            if (m.isDaoAware()) {
                DaoGenerator.this.print(", this);%n", new Object[0]);
            } else {
                DaoGenerator.this.print(");%n", new Object[0]);
            }
            QueryReturnMeta resultMeta = m.getReturnMeta();
            if ("void".equals(resultMeta.getTypeName())) {
                DaoGenerator.this.iprint("Object __result = null;%n", new Object[0]);
                DaoGenerator.this.iprint("", new Object[0]);
            } else {
                DaoGenerator.this.iprint("%1$s __result = ", resultMeta.getTypeName());
            }
            DaoGenerator.this.print("__delegate.%1$s(", m.getName());
            Iterator<QueryParameterMeta> it = m.getParameterMetas().iterator();
            while (it.hasNext()) {
                QueryParameterMeta parameterMeta = it.next();
                DaoGenerator.this.print("%1$s", parameterMeta.getName());
                if (!it.hasNext()) continue;
                DaoGenerator.this.print(", ", new Object[0]);
            }
            DaoGenerator.this.print(");%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.qualifiedName, m.getName());
            if (!"void".equals(resultMeta.getTypeName())) {
                DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            }
            this.printThrowingStatements(m);
            return null;
        }

        protected void printEnteringStatements(QueryMeta m) {
            DaoGenerator.this.iprint("entering(\"%1$s\", \"%2$s\"", DaoGenerator.this.qualifiedName, m.getName());
            for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
                DaoGenerator.this.print(", %1$s", parameterMeta.getName());
            }
            DaoGenerator.this.print(");%n", new Object[0]);
            DaoGenerator.this.iprint("try {%n", new Object[0]);
            DaoGenerator.this.indent();
        }

        protected void printArrayCreateEnteringStatements(ArrayCreateQueryMeta m) {
            DaoGenerator.this.iprint("entering(\"%1$s\", \"%2$s\", (Object)%3$s);%n", DaoGenerator.this.qualifiedName, m.getName(), m.getParameterName());
            DaoGenerator.this.iprint("try {%n", new Object[0]);
            DaoGenerator.this.indent();
        }

        protected void printThrowingStatements(QueryMeta m) {
            DaoGenerator.this.unindent();
            DaoGenerator.this.iprint("} catch (%1$s __e) {%n", RuntimeException.class.getName());
            DaoGenerator.this.indent();
            DaoGenerator.this.iprint("throwing(\"%1$s\", \"%2$s\", __e);%n", DaoGenerator.this.qualifiedName, m.getName());
            DaoGenerator.this.iprint("throw __e;%n", new Object[0]);
            DaoGenerator.this.unindent();
            DaoGenerator.this.iprint("}%n", new Object[0]);
        }

        protected void printPrerequisiteStatements(QueryMeta m) {
            for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
                if (parameterMeta.isNullable()) continue;
                String paramName = parameterMeta.getName();
                DaoGenerator.this.iprint("if (%1$s == null) {%n", paramName);
                DaoGenerator.this.iprint("    throw new %1$s(\"%2$s\");%n", DomaNullPointerException.class.getName(), paramName);
                DaoGenerator.this.iprint("}%n", new Object[0]);
            }
        }
    }
}

