/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.IOUtil;

public final class ResourceUtil {
    public static URL getResource(String path) {
        AssertionUtil.assertNotNull(path);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource(path);
        if (url == null) {
            url = ResourceUtil.class.getResource("/" + path);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String path) {
        AssertionUtil.assertNotNull(path);
        URL url = ResourceUtil.getResource(path);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getResourceAsString(String path) throws WrapException {
        AssertionUtil.assertNotNull(path);
        AssertionUtil.assertTrue(path.length() > 0, new Object[0]);
        InputStream inputStream = ResourceUtil.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return IOUtil.readAsString(inputStream);
    }
}

