/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.ValueArrayDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class MVPrimaryIndex
extends BaseIndex {
    private final MVTable mvTable;
    private MVMap<Long, Value[]> map;
    private long lastKey;
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database database, MVTable mVTable, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, mVTable.getName() + "_DATA", indexColumnArray, indexType);
        int[] nArray = new int[indexColumnArray.length];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = 0;
        }
        ValueArrayDataType valueArrayDataType = new ValueArrayDataType(database.getCompareMode(), database, nArray);
        this.map = mVTable.getStore().openMap(this.getName() + "_" + this.getId(), new MVMap.Builder().valueType(valueArrayDataType));
        Long l = this.map.lastKey();
        this.lastKey = l == null ? 0L : l;
    }

    public void renameTable(String string) {
        MVMap<Long, Value[]> mVMap = this.getMap(null);
        this.rename(string + "_DATA");
        mVMap.renameMap(string + "_DATA_" + this.getId());
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        Value[] valueArray;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(++this.lastKey);
            }
        } else {
            valueArray = Long.valueOf(row.getValue(this.mainIndexColumn).getLong());
            row.setKey(valueArray.longValue());
        }
        valueArray = new Value[this.columns.length];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = row.getValue(i);
        }
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        if (mVMap.containsKey(row.getKey())) {
            String string = "PRIMARY KEY ON " + this.table.getSQL();
            if (this.mainIndexColumn >= 0 && this.mainIndexColumn < this.indexColumns.length) {
                string = string + "(" + this.indexColumns[this.mainIndexColumn].getSQL() + ")";
            }
            DbException dbException = DbException.get(23505, string);
            dbException.setSource(this);
            throw dbException;
        }
        mVMap.put(row.getKey(), valueArray);
        this.lastKey = Math.max(this.lastKey, row.getKey());
    }

    @Override
    public void remove(Session session, Row row) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        Value[] valueArray = mVMap.remove(row.getKey());
        if (valueArray == null) {
            throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Object object;
        long l = searchRow == null || this.mainIndexColumn < 0 ? Long.MIN_VALUE : ((object = searchRow.getValue(this.mainIndexColumn)) == null ? 0L : ((Value)object).getLong());
        long l2 = searchRow2 == null || this.mainIndexColumn < 0 ? Long.MAX_VALUE : ((object = searchRow2.getValue(this.mainIndexColumn)) == null ? Long.MAX_VALUE : ((Value)object).getLong());
        object = this.getMap(session);
        return new MVStoreCursor(session, ((MVMap)object).keyIterator(l), l2);
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(Session session, long l) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        Value[] valueArray = mVMap.get(l);
        Row row = new Row(valueArray, 0);
        row.setKey(l);
        return row;
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        long l = 10L * (mVMap.getSize() + 1000L);
        return l;
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void remove(Session session) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        if (!mVMap.isClosed()) {
            mVMap.removeMap();
        }
    }

    @Override
    public void truncate(Session session) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        mVMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        if (mVMap.getSize() == 0L) {
            return new MVStoreCursor(session, Collections.emptyList().iterator(), 0L);
        }
        long l = bl ? mVMap.firstKey() : mVMap.lastKey();
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, Arrays.asList(l).iterator(), l);
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        return mVMap.getSize();
    }

    @Override
    public long getRowCountApproximation() {
        MVMap<Long, Value[]> mVMap = this.getMap(null);
        return mVMap.getSize();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    long getKey(SearchRow searchRow, long l, long l2) {
        if (searchRow == null) {
            return l;
        }
        Value value = searchRow.getValue(this.mainIndexColumn);
        if (value == null) {
            throw DbException.throwInternalError(searchRow.toString());
        }
        if (value == ValueNull.INSTANCE) {
            return l2;
        }
        return value.getLong();
    }

    Cursor find(Session session, long l, long l2) {
        MVMap<Long, Value[]> mVMap = this.getMap(session);
        return new MVStoreCursor(session, mVMap.keyIterator(l), l2);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    MVMap<Long, Value[]> getMap(Session session) {
        return this.map;
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Long> it;
        private final long last;
        private Long current;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Long> iterator, long l) {
            this.session = session;
            this.it = iterator;
            this.last = l;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                this.row = MVPrimaryIndex.this.getRow(this.session, this.current);
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.next();
            if (this.current != null && this.current > this.last) {
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            return false;
        }
    }
}

