/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.timer.DelegatingTimerTask;
import org.springframework.util.Assert;

public class TimerTaskExecutor
implements SchedulingTaskExecutor,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Timer timer;
    private int delay = 0;
    private boolean timerInternal = false;

    public TimerTaskExecutor() {
    }

    public TimerTaskExecutor(Timer timer) {
        Assert.notNull((Object)timer, (String)"Timer must not be null");
        this.timer = timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void afterPropertiesSet() {
        if (this.timer == null) {
            this.logger.info((Object)"Initializing Timer");
            this.timer = this.createTimer();
            this.timerInternal = true;
        }
    }

    protected Timer createTimer() {
        return new Timer(true);
    }

    public void execute(Runnable task) {
        Assert.notNull((Object)this.timer, (String)"Timer is required");
        this.timer.schedule((TimerTask)new DelegatingTimerTask(task), this.delay);
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void destroy() {
        if (this.timerInternal) {
            this.logger.info((Object)"Cancelling Timer");
            this.timer.cancel();
        }
    }
}

