/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ModifierUtil;

public class PointcutImpl
implements Pointcut,
Serializable {
    static final long serialVersionUID = 0L;
    private String[] methodNames;
    private Pattern[] patterns;
    private Method method;
    static /* synthetic */ Class class$java$lang$Object;

    public PointcutImpl(Class targetClass) throws EmptyRuntimeException {
        if (targetClass == null) {
            throw new EmptyRuntimeException("targetClass");
        }
        this.setMethodNames(PointcutImpl.getMethodNames(targetClass));
    }

    public PointcutImpl(String[] methodNames) throws EmptyRuntimeException {
        if (methodNames == null || methodNames.length == 0) {
            throw new EmptyRuntimeException("methodNames");
        }
        this.setMethodNames(methodNames);
    }

    public PointcutImpl(Method method) {
        this.method = method;
    }

    public boolean isApplied(Method targetMethod) {
        if (this.method != null) {
            return this.method.equals(targetMethod);
        }
        String methodName = targetMethod.getName();
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(methodName).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    private void setMethodNames(String[] methodNames) {
        this.methodNames = methodNames;
        this.patterns = new Pattern[methodNames.length];
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = Pattern.compile(methodNames[i]);
        }
    }

    private static String[] getMethodNames(Class targetClass) {
        HashSet methodNameSet = new HashSet();
        if (targetClass.isInterface()) {
            PointcutImpl.addInterfaceMethodNames(methodNameSet, targetClass);
        }
        for (Class clazz = targetClass; clazz != (class$java$lang$Object == null ? PointcutImpl.class$("java.lang.Object") : class$java$lang$Object) && clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                PointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
            }
        }
        if (methodNameSet.isEmpty()) {
            PointcutImpl.addClassMethodNames(methodNameSet, targetClass);
        }
        return methodNameSet.toArray(new String[methodNameSet.size()]);
    }

    private static void addInterfaceMethodNames(Set methodNameSet, Class interfaceClass) {
        Method[] methods = interfaceClass.getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            methodNameSet.add(methods[j].getName());
        }
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            PointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
        }
    }

    private static void addClassMethodNames(Set methodNameSet, Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (MethodUtil.isSyntheticMethod(method) || MethodUtil.isBridgeMethod(method) || ModifierUtil.isFinal(method) || method.getDeclaringClass() == (class$java$lang$Object == null ? PointcutImpl.class$("java.lang.Object") : class$java$lang$Object)) continue;
            methodNameSet.add(methods[i].getName());
        }
    }
}

