/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTokenConverter
extends DynamicConverter {
    String datePattern;
    SimpleDateFormat sdf;

    public void start() {
        this.datePattern = this.getFirstOption();
        if (this.datePattern == null) {
            this.datePattern = "yyyy-MM-dd";
        }
        this.sdf = new SimpleDateFormat(this.datePattern);
    }

    public String convert(Date date) {
        return this.sdf.format(date);
    }

    public String convert(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (o instanceof Date) {
            return this.convert((Date)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " of type" + o.getClass().getName());
    }

    public String getDatePattern() {
        return this.datePattern;
    }
}

