/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.util;

import java.lang.reflect.Method;
import org.seasar.cubby.action.Accept;
import org.seasar.cubby.action.OnSubmit;
import org.seasar.cubby.action.Path;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaUtils {
    private static final String INDEX_METHOD_NAME = "index";
    private static final Accept DEFAULT_ACCEPT_ANNOTATION;

    public static String getActionDirectory(Class<?> actionClass) {
        String actionName;
        Path path = actionClass.getAnnotation(Path.class);
        if (path != null && !StringUtils.isEmpty(path.value())) {
            actionName = path.value();
        } else {
            String name = MetaUtils.left(actionClass.getSimpleName(), "$");
            actionName = MetaUtils.toFirstLower(name.replaceAll("(.*[.])*([^.]+)(Action$)", "$2"));
        }
        return actionName;
    }

    private static String left(String text, String sep) {
        int pos = text.indexOf(sep);
        if (pos != -1) {
            return text.substring(0, pos);
        }
        return text;
    }

    private static String toFirstLower(String text) {
        if (StringUtils.isEmpty(text)) {
            throw new IllegalArgumentException("text is empty.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(text.substring(0, 1).toLowerCase());
        if (text.length() > 1) {
            sb.append(text.substring(1));
        }
        return sb.toString();
    }

    public static String getActionPath(Class<?> actionClass, Method method) {
        String actionDirectory;
        String actionMethodName = MetaUtils.getActionMethodName(method);
        String path = actionMethodName.startsWith("/") ? actionMethodName : ("/".equals(actionDirectory = MetaUtils.getActionDirectory(actionClass)) ? "/" + actionMethodName : "/" + actionDirectory + "/" + actionMethodName);
        return path;
    }

    private static String getActionMethodName(Method method) {
        String methodName;
        Path path = method.getAnnotation(Path.class);
        String actionName = path != null && !StringUtils.isEmpty(path.value()) ? ("/".equals(path.value()) ? "" : path.value()) : (INDEX_METHOD_NAME.equals(methodName = method.getName()) ? "" : methodName);
        return actionName;
    }

    public static RequestMethod[] getAcceptableRequestMethods(Class<?> actionClass, Method method) {
        Accept accept = method.isAnnotationPresent(Accept.class) ? method.getAnnotation(Accept.class) : (actionClass.isAnnotationPresent(Accept.class) ? actionClass.getAnnotation(Accept.class) : DEFAULT_ACCEPT_ANNOTATION);
        return accept.value();
    }

    public static int getPriority(Method method) {
        Path path = method.getAnnotation(Path.class);
        return path != null ? path.priority() : Integer.MAX_VALUE;
    }

    public static String getOnSubmit(Method method) {
        OnSubmit onSubmit = method.getAnnotation(OnSubmit.class);
        String parameterName = onSubmit == null ? null : onSubmit.value();
        return parameterName;
    }

    static {
        @Accept
        class AcceptDummy {
            AcceptDummy() {
            }
        }
        DEFAULT_ACCEPT_ANNOTATION = AcceptDummy.class.getAnnotation(Accept.class);
    }
}

