/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class MaxLengthValidator
implements ScalarFieldValidator {
    private final String messageKey;
    private final int max;

    public MaxLengthValidator(int max) {
        this(max, "valid.maxLength");
    }

    public MaxLengthValidator(int max, String messageKey) {
        this.max = max;
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            if (str.length() <= this.max) {
                return;
            }
        } else if (value == null) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        messageInfo.setArguments(this.max);
        context.addMessageInfo(messageInfo);
    }
}

