/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTag;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;
import org.seasar.cubby.tags.CubbyFunctions;
import org.seasar.cubby.tags.DynamicAttributesSimpleTagSupport;
import org.seasar.cubby.tags.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTag
extends DynamicAttributesSimpleTagSupport {
    private String name;
    private Object items;
    private String labelProperty;
    private String valueProperty;
    private Boolean emptyOption = Boolean.TRUE;
    private String emptyOptionLabel;

    public void setItems(Object items) {
        this.items = items;
    }

    public void setLabelProperty(String labelProperty) {
        this.labelProperty = labelProperty;
    }

    public void setValueProperty(String valueProperty) {
        this.valueProperty = valueProperty;
    }

    public void setEmptyOption(Boolean emptyOption) {
        this.emptyOption = emptyOption;
    }

    public void setEmptyOptionLabel(String emptyOptionLabel) {
        this.emptyOptionLabel = emptyOptionLabel;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    public void doTag() throws JspException, IOException {
        if (this.items == null) {
            throw new JspTagException(LogMessages.format("ECUB1005", new Object[0]));
        }
        JspContext context = this.getJspContext();
        JspWriter out = context.getOut();
        ActionErrors errors = TagUtils.errors(context);
        Map<String, Object> dyn = this.getDynamicAttributes();
        FormWrapper formWrapper = TagUtils.getFormWrapper((SimpleTag)this);
        if (!errors.getFields().get(this.name).isEmpty()) {
            TagUtils.addCSSClassName(dyn, "fieldError");
        }
        Object[] value = TagUtils.multipleFormValues(context, formWrapper, this.name);
        out.write("<select name=\"");
        out.write(this.name);
        out.write("\" ");
        out.write(TagUtils.toAttr(dyn));
        out.write(">\n");
        if (this.emptyOption.booleanValue()) {
            out.write("<option value=\"\">");
            out.write(CubbyFunctions.out(this.emptyOptionLabel));
            out.write("</option>\n");
        }
        if (this.items != null && this.items.getClass().isArray()) {
            void var10_14;
            OptionWriter optionWriter = new OptionWriter(new BeanItemAdaptor());
            Object[] arr$ = (Object[])this.items;
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_14 < len$) {
                Object item = arr$[var10_14];
                optionWriter.write(out, item, value);
                ++var10_14;
            }
        } else {
            Set collection;
            OptionWriter optionWriter;
            if (this.items instanceof Collection) {
                optionWriter = new OptionWriter(new BeanItemAdaptor());
                collection = (Set)this.items;
            } else if (this.items instanceof Map) {
                optionWriter = new OptionWriter(new EntryItemAdaptor());
                collection = ((Map)this.items).entrySet();
            } else {
                throw new JspTagException(LogMessages.format("ECUB1001", "items", this.items == null ? null : this.items.getClass()));
            }
            for (Object e : collection) {
                optionWriter.write(out, e, value);
            }
        }
        out.write("</select>");
    }

    private class EntryItemAdaptor
    implements ItemAdaptor {
        EntryItemAdaptor() {
            Logger logger;
            if (SelectTag.this.valueProperty != null && (logger = LoggerFactory.getLogger(SelectTag.class)).isWarnEnabled()) {
                logger.warn(LogMessages.format("WCUB1001", "items", Map.class.getSimpleName(), "valueProperty", SelectTag.this.valueProperty, Map.Entry.class.getSimpleName() + "#getKey()"));
            }
            if (SelectTag.this.labelProperty != null && (logger = LoggerFactory.getLogger(SelectTag.class)).isWarnEnabled()) {
                logger.warn(LogMessages.format("WCUB1002", "items", Map.class.getSimpleName(), "labelProperty", SelectTag.this.labelProperty, Map.Entry.class.getSimpleName() + "#getValue()"));
            }
        }

        public Object getItemValue(Object item) {
            return ((Map.Entry)item).getKey();
        }

        public Object getLabelValue(Object item) {
            return ((Map.Entry)item).getValue();
        }
    }

    private class BeanItemAdaptor
    implements ItemAdaptor {
        BeanItemAdaptor() throws JspTagException {
            if (SelectTag.this.valueProperty == null) {
                throw new JspTagException(LogMessages.format("ECUB1002", "items", "valueProperty"));
            }
        }

        public Object getItemValue(Object item) {
            return this.property(item, SelectTag.this.valueProperty);
        }

        public Object getLabelValue(Object item) {
            Object labelValue = SelectTag.this.labelProperty == null ? this.getItemValue(item) : this.property(item, SelectTag.this.labelProperty);
            return labelValue;
        }

        private Object property(Object bean, String propertyName) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
            Attribute attribute = beanDesc.getPropertyAttribute(propertyName);
            return attribute.getValue(bean);
        }
    }

    private static interface ItemAdaptor {
        public Object getItemValue(Object var1);

        public Object getLabelValue(Object var1);
    }

    private static class OptionWriter {
        private final ItemAdaptor itemAdaptor;

        OptionWriter(ItemAdaptor itemAdaptor) {
            this.itemAdaptor = itemAdaptor;
        }

        void write(JspWriter out, Object item, Object value) throws IOException {
            out.write("<option value=\"");
            String itemValue = TagUtils.toString(this.itemAdaptor.getItemValue(item));
            String labelValue = TagUtils.toString(this.itemAdaptor.getLabelValue(item));
            out.write(CubbyFunctions.out(itemValue));
            out.write("\" ");
            out.write(this.selected(itemValue, value));
            out.write(">");
            out.write(CubbyFunctions.out(labelValue));
            out.write("</option>\n");
        }

        private String selected(String value, Object values) {
            if (value == null || values == null) {
                return "";
            }
            if (TagUtils.contains(values, value)) {
                return "selected=\"selected\"";
            }
            return "";
        }
    }
}

