/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.WriterAppender;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAppender<E>
extends WriterAppender<E> {
    protected boolean append = true;
    protected String fileName = null;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;
    private boolean prudent = false;
    private FileChannel fileChannel = null;

    public void setFile(String file) {
        String val;
        this.fileName = file == null ? file : (val = file.trim());
    }

    public boolean getAppend() {
        return this.append;
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int errors = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent) {
                if (!this.isAppend()) {
                    this.setAppend(true);
                    this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
                }
                if (!this.getImmediateFlush()) {
                    this.setImmediateFlush(true);
                    this.addWarn("Setting \"ImmediateFlush\" to true on account of \"Prudent\" mode");
                }
                if (this.bufferedIO) {
                    this.setBufferedIO(false);
                    this.addWarn("Setting \"BufferedIO\" property to false on account of \"Prudent\" mode");
                }
            }
            if (this.bufferedIO) {
                this.setImmediateFlush(false);
                this.addInfo("Setting \"ImmediateFlush\" property to false on account of \"bufferedIO\" property");
            }
            try {
                this.openFile(this.getFile());
            }
            catch (IOException e) {
                ++errors;
                this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", e);
            }
        } else {
            ++errors;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (errors == 0) {
            super.start();
        }
    }

    public synchronized void openFile(String file_name) throws IOException {
        boolean result;
        File file = new File(file_name);
        if (FileUtil.mustCreateParentDirectories(file) && !(result = FileUtil.createMissingParentDirectories(file))) {
            this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file_name, this.append);
        if (this.prudent) {
            this.fileChannel = fileOutputStream.getChannel();
        }
        Writer w = this.createWriter(fileOutputStream);
        if (this.bufferedIO) {
            w = new BufferedWriter(w, this.bufferSize);
        }
        this.setWriter(w);
    }

    public boolean isBufferedIO() {
        return this.bufferedIO;
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.bufferedIO = bufferedIO;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean prudent) {
        this.prudent = prudent;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void safeWrite(String s) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = this.fileChannel.lock();
            long position = this.fileChannel.position();
            long size = this.fileChannel.size();
            if (size != position) {
                this.fileChannel.position(size);
            }
            super.writerWrite(s, true);
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
        }
    }

    @Override
    protected void writerWrite(String s, boolean flush) throws IOException {
        if (this.prudent && this.fileChannel != null) {
            this.safeWrite(s);
        } else {
            super.writerWrite(s, flush);
        }
    }
}

