/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableToDataPointArray {
    static final ThrowableDataPoint[] TEMPLATE_ARRAY = new ThrowableDataPoint[0];

    public static ThrowableDataPoint[] convert(Throwable t) {
        LinkedList<ThrowableDataPoint> tdpList = new LinkedList<ThrowableDataPoint>();
        ThrowableToDataPointArray.extract(tdpList, t, null);
        return tdpList.toArray(TEMPLATE_ARRAY);
    }

    private static void extract(List<ThrowableDataPoint> tdpList, Throwable t, StackTraceElement[] parentSTE) {
        Throwable cause;
        StackTraceElement[] ste = t.getStackTrace();
        int numberOfcommonFrames = STEUtil.findNumberOfCommonFrames(ste, parentSTE);
        tdpList.add(ThrowableToDataPointArray.firstLineToDataPoint(t, parentSTE));
        for (int i = 0; i < ste.length - numberOfcommonFrames; ++i) {
            tdpList.add(new ThrowableDataPoint(ste[i]));
        }
        if (numberOfcommonFrames != 0) {
            tdpList.add(new ThrowableDataPoint("\t... " + numberOfcommonFrames + " common frames omitted"));
        }
        if ((cause = t.getCause()) != null) {
            ThrowableToDataPointArray.extract(tdpList, cause, ste);
        }
    }

    private static ThrowableDataPoint firstLineToDataPoint(Throwable t, StackTraceElement[] parentSTE) {
        String prefix = "";
        if (parentSTE != null) {
            prefix = "Caused by: ";
        }
        String result = prefix + t.getClass().getName();
        if (t.getMessage() != null) {
            result = result + ": " + t.getMessage();
        }
        return new ThrowableDataPoint(result);
    }
}

