/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2.spi;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.seasar.cubby.plugins.s2.detector.ClassDetector;
import org.seasar.cubby.plugins.s2.detector.DetectClassProcessor;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.util.ActionUtils;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class S2PathResolverProvider
implements PathResolverProvider,
DetectClassProcessor,
Disposable {
    public static final String pathResolver_BINDING = "bindingType=must";
    public static final String namingConvention_BINDING = "bindingType=must";
    public static final String classDetector_BINDING = "bindingType=must";
    private PathResolver pathResolver;
    private NamingConvention namingConvention;
    public ClassDetector classDetector;
    private boolean initialized;
    private final List<Class<?>> actionClasses = new ArrayList();

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public void setClassDetector(ClassDetector classDetector) {
        this.classDetector = classDetector;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        PathResolver pathResolver = this.pathResolver;
        synchronized (pathResolver) {
            if (this.initialized) {
                return;
            }
            this.classDetector.detect();
            this.pathResolver.addAll(this.actionClasses);
            DisposableUtil.add((Disposable)this);
            this.initialized = true;
        }
    }

    public void dispose() {
        this.actionClasses.clear();
        this.pathResolver.clear();
        this.initialized = false;
    }

    public void processClass(String packageName, String shortClassName) {
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = ClassUtil.concatName((String)packageName, (String)shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        if (!className.endsWith(this.namingConvention.getActionSuffix())) {
            return;
        }
        Class clazz = ClassUtil.forName((String)className);
        if (this.namingConvention.isSkipClass(clazz)) {
            return;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        if (!ActionUtils.isActionClass((Class)clazz)) {
            return;
        }
        this.actionClasses.add(clazz);
    }

    public PathResolver getPathResolver() {
        this.initialize();
        return this.pathResolver;
    }
}

