/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2.detector.impl;

import java.util.HashSet;
import java.util.Set;
import org.seasar.cubby.plugins.s2.detector.ClassDetector;
import org.seasar.cubby.plugins.s2.detector.DetectClassProcessor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.cooldeploy.CoolComponentAutoRegister;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class ClassDetectorImpl
extends CoolComponentAutoRegister
implements ClassDetector,
Disposable {
    public static final String INIT_METHOD = null;
    private boolean initialized;
    private DetectClassProcessor[] processors;
    private final Set<String> processedClasses = new HashSet<String>();

    public void processClass(String packageName, String shortClassName) {
        String fqcn = ClassUtil.concatName((String)packageName, (String)shortClassName);
        if (!this.processedClasses.contains(fqcn)) {
            this.processedClasses.add(fqcn);
            for (DetectClassProcessor processor : this.processors) {
                processor.processClass(packageName, shortClassName);
            }
        }
    }

    public void detect() {
        if (!this.initialized) {
            this.processedClasses.clear();
            this.processors = (DetectClassProcessor[])this.getContainer().getRoot().findAllComponents(DetectClassProcessor.class);
            this.registerAll();
            this.processedClasses.clear();
            DisposableUtil.add((Disposable)this);
            this.initialized = true;
        }
    }

    public void dispose() {
        this.initialized = false;
    }

    protected ComponentDef createComponentDef(Class componentClass) {
        throw new UnsupportedOperationException();
    }
}

