/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.customizer;

import java.util.ArrayList;
import java.util.List;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.util.ClassUtil;

public abstract class AbstractCustomizer
implements ComponentCustomizer {
    public static final String targetInterface_BINDING = "bindingType=may";
    protected final List classPatterns = new ArrayList();
    protected final List ignoreClassPatterns = new ArrayList();
    protected Class targetInterface;

    public void addClassPattern(String packageName, String shortClassNames) {
        this.addClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public void addClassPattern(ClassPattern classPattern) {
        this.classPatterns.add(classPattern);
    }

    public void addIgnoreClassPattern(String packageName, String shortClassNames) {
        this.addIgnoreClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public void addIgnoreClassPattern(ClassPattern classPattern) {
        this.ignoreClassPatterns.add(classPattern);
    }

    public void setTargetInterface(Class targetInterface) {
        if (!targetInterface.isInterface()) {
            throw new IllegalArgumentException(targetInterface.getName());
        }
        this.targetInterface = targetInterface;
    }

    public void customize(ComponentDef componentDef) {
        if (!this.isMatchClassPattern(componentDef)) {
            return;
        }
        if (!this.isMatchTargetInterface(componentDef)) {
            return;
        }
        this.doCustomize(componentDef);
    }

    protected boolean isMatchClassPattern(ComponentDef componentDef) {
        ClassPattern cp;
        int i;
        if (this.classPatterns.isEmpty() && this.ignoreClassPatterns.isEmpty()) {
            return true;
        }
        Class clazz = componentDef.getComponentClass();
        if (clazz == null) {
            return false;
        }
        String packageName = ClassUtil.getPackageName(clazz);
        String shortClassName = ClassUtil.getShortClassName(clazz);
        for (i = 0; i < this.ignoreClassPatterns.size(); ++i) {
            cp = (ClassPattern)this.ignoreClassPatterns.get(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            return false;
        }
        if (this.classPatterns.isEmpty()) {
            return true;
        }
        for (i = 0; i < this.classPatterns.size(); ++i) {
            cp = (ClassPattern)this.classPatterns.get(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatchTargetInterface(ComponentDef componentDef) {
        if (this.targetInterface == null) {
            return true;
        }
        Class clazz = componentDef.getComponentClass();
        if (clazz == null) {
            return false;
        }
        return this.targetInterface.isAssignableFrom(clazz);
    }

    protected abstract void doCustomize(ComponentDef var1);
}

