/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionException;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.MetaUtils;
import org.seasar.cubby.internal.util.QueryStringBuilder;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.util.LinkBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Redirect
implements ActionResult {
    private static final Logger logger = LoggerFactory.getLogger(Redirect.class);
    private static final Map<String, String[]> EMPTY_PARAMETERS = Collections.emptyMap();
    private final PathResolverProvider pathResolverProvider;
    private final LinkBuilder linkBuilder = new LinkBuilder();
    private String path;
    private Class<?> actionClass;
    private String methodName;
    private Map<String, String[]> parameters;
    private String characterEncoding;
    private boolean encodeURL = true;

    public Redirect(String path) {
        this.pathResolverProvider = null;
        this.path = path;
    }

    public Redirect(String path, String protocol) {
        this(path);
        this.linkBuilder.setProtocol(protocol);
    }

    public Redirect(String path, String protocol, int port) {
        this(path);
        this.linkBuilder.setProtocol(protocol);
        this.linkBuilder.setPort(port);
    }

    public Redirect(Class<?> actionClass) {
        this(actionClass, "index");
    }

    public Redirect(Class<?> actionClass, String methodName) {
        this(actionClass, methodName, EMPTY_PARAMETERS);
    }

    public Redirect(Class<?> actionClass, String methodName, Map<String, String[]> parameters) {
        this.pathResolverProvider = ProviderFactory.get(PathResolverProvider.class);
        this.actionClass = actionClass;
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public Redirect(Class<?> actionClass, String methodName, Map<String, String[]> parameters, String protocol) {
        this(actionClass, methodName, parameters);
        this.linkBuilder.setProtocol(protocol);
    }

    public Redirect(Class<?> actionClass, String methodName, Map<String, String[]> parameters, String protocol, int port) {
        this(actionClass, methodName, parameters);
        this.linkBuilder.setProtocol(protocol);
        this.linkBuilder.setPort(port);
    }

    public String getPath(String characterEncoding) {
        if (this.isReverseLookupRedirect()) {
            String redirectPath;
            PathResolver pathResolver = this.pathResolverProvider.getPathResolver();
            this.path = redirectPath = pathResolver.reverseLookup(this.actionClass, this.methodName, this.parameters, characterEncoding);
        }
        return this.path;
    }

    private boolean isReverseLookupRedirect() {
        return this.actionClass != null && this.methodName != null && this.parameters != null;
    }

    @Override
    public void execute(ActionContext actionContext, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String characterEncoding = this.characterEncoding == null ? request.getCharacterEncoding() : this.characterEncoding;
        String redirectURL = this.calculateRedirectURL(this.getPath(characterEncoding), actionContext.getActionClass(), request);
        String encodedRedirectURL = this.encodeURL(redirectURL, response);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0003", encodedRedirectURL));
        }
        response.sendRedirect(encodedRedirectURL);
    }

    protected String calculateRedirectURL(String path, Class<?> actionClass, HttpServletRequest request) {
        try {
            String redirectURL = new URL(path).toExternalForm();
            return redirectURL;
        }
        catch (MalformedURLException e) {
            String redirectURL = this.calculateInternalRedirectURL(path, actionClass, request);
            return redirectURL;
        }
    }

    private String calculateInternalRedirectURL(String path, Class<?> actionClass, HttpServletRequest request) {
        String redirectPath;
        String contextPath = "/".equals(request.getContextPath()) ? "" : request.getContextPath();
        if (path.startsWith("/")) {
            redirectPath = contextPath + path;
        } else {
            String actionDirectory = MetaUtils.getActionDirectory(actionClass);
            if (StringUtils.isEmpty(actionDirectory)) {
                StringBuilder builder = new StringBuilder();
                builder.append(contextPath);
                if (!contextPath.endsWith("/")) {
                    builder.append("/");
                }
                builder.append(path);
                redirectPath = builder.toString();
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append(contextPath);
                if (!contextPath.endsWith("/") && !actionDirectory.startsWith("/")) {
                    builder.append("/");
                }
                builder.append(actionDirectory);
                if (!actionDirectory.endsWith("/")) {
                    builder.append("/");
                }
                builder.append(path);
                redirectPath = builder.toString();
            }
        }
        try {
            return this.linkBuilder.file(redirectPath).toLink(request);
        }
        catch (MalformedURLException e) {
            throw new ActionException(e);
        }
    }

    protected String encodeURL(String url, HttpServletResponse response) {
        if (this.encodeURL) {
            return response.encodeRedirectURL(url);
        }
        return url;
    }

    public Redirect noEncodeURL() {
        this.encodeURL = false;
        return this;
    }

    public Redirect param(String paramName, Object paramValue) {
        return this.param(paramName, new String[]{paramValue.toString()});
    }

    public Redirect param(String paramName, Object[] paramValues) {
        return this.param(paramName, this.toStringArray(paramValues));
    }

    public Redirect param(String paramName, String[] paramValues) {
        if (this.isReverseLookupRedirect()) {
            if (this.parameters == EMPTY_PARAMETERS) {
                this.parameters = new HashMap<String, String[]>();
            }
            this.parameters.put(paramName, paramValues);
        } else {
            QueryStringBuilder builder = new QueryStringBuilder(this.path);
            builder.addParam(paramName, paramValues);
            this.path = builder.toString();
        }
        return this;
    }

    private String[] toStringArray(Object[] paramValues) {
        String[] values = new String[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            values[i] = paramValues[i].toString();
        }
        return values;
    }

    public Redirect characterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        return this;
    }

    @Deprecated
    public String getPath() {
        return this.getPath("UTF-8");
    }
}

