/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.seasar.framework.jpa.PersistenceClassTransformer;
import org.seasar.framework.jpa.impl.PersistenceUnitInfoImpl;
import org.seasar.framework.jpa.util.ChildFirstClassLoader;
import org.seasar.framework.jpa.util.ClassLoaderEvent;
import org.seasar.framework.jpa.util.ClassLoaderListener;
import org.seasar.framework.jpa.util.ClassTransformerUtil;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.IterableAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceClassTransformerImpl
implements PersistenceClassTransformer {
    protected Set<String> ignoreLoaderClassNames = CollectionsUtil.newHashSet();

    public void addIgnoreLoaderClassName(String ignoreLoaderClassName) {
        this.ignoreLoaderClassNames.add(ignoreLoaderClassName);
    }

    @Override
    public void transform(PersistenceUnitInfo unitInfo) {
        final List<ClassTransformer> transformers = ((PersistenceUnitInfoImpl)PersistenceUnitInfoImpl.class.cast(unitInfo)).getTransformers();
        ClassLoader classLoader = unitInfo.getClassLoader();
        final ClassLoader targetLoader = this.getTargetClassLoader(classLoader);
        ChildFirstClassLoader tempLoader = new ChildFirstClassLoader(targetLoader);
        tempLoader.addClassLoaderListener(new ClassLoaderListener(){

            public void classFinded(ClassLoaderEvent event) {
                String className = event.getClassName();
                byte[] bytes = event.getBytecode();
                for (ClassTransformer transformer : transformers) {
                    bytes = PersistenceClassTransformerImpl.this.transform(transformer, targetLoader, className, bytes);
                }
                ClassLoaderUtil.defineClass((ClassLoader)targetLoader, (String)className, (byte[])bytes, (int)0, (int)bytes.length);
            }
        });
        this.loadPersistenceClasses(unitInfo, tempLoader);
    }

    @Override
    public Class<?> transform(PersistenceUnitInfo unitInfo, String className, byte[] bytecode) {
        List<ClassTransformer> transformers = ((PersistenceUnitInfoImpl)PersistenceUnitInfoImpl.class.cast(unitInfo)).getTransformers();
        ClassLoader classLoader = unitInfo.getClassLoader();
        ClassLoader targetLoader = this.getTargetClassLoader(classLoader);
        byte[] bytes = bytecode;
        for (ClassTransformer transformer : transformers) {
            bytes = this.transform(transformer, targetLoader, className, bytes);
        }
        return ClassLoaderUtil.defineClass((ClassLoader)targetLoader, (String)className, (byte[])bytes, (int)0, (int)bytes.length);
    }

    protected void loadPersistenceClasses(PersistenceUnitInfo unitInfo, ClassLoader loader) {
        for (String className : unitInfo.getManagedClassNames()) {
            this.loadClass(loader, className);
        }
        for (URL jarFileUrl : unitInfo.getJarFileUrls()) {
            this.loadClass(loader, jarFileUrl);
        }
        if (!unitInfo.excludeUnlistedClasses()) {
            URL rootUrl = unitInfo.getPersistenceUnitRootUrl();
            if ("file".equals(rootUrl.getProtocol())) {
                this.loadClass(loader, URLUtil.toFile((URL)rootUrl), null);
            } else {
                this.loadClass(loader, FileUtil.toURL((File)new File(JarFileUtil.toJarFilePath((URL)rootUrl))));
            }
        }
    }

    protected void loadClass(ClassLoader loader, String className) {
        try {
            loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoaderUtil.loadClass((ClassLoader)loader, (String)(className + ".package-info"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadClass(ClassLoader loader, URL jarFileUrl) {
        JarFile jarFile = JarFileUtil.create((String)jarFileUrl.getPath());
        try {
            for (JarEntry entry : IterableAdapter.iterable(jarFile.entries())) {
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.endsWith(".class")) continue;
                String className = this.removeExtension(entryName).replace('/', '.');
                this.loadClass(loader, className);
            }
        }
        finally {
            JarFileUtil.close((JarFile)jarFile);
        }
    }

    protected void loadClass(ClassLoader loader, File dir, String path) {
        for (File file : dir.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                this.loadClass(loader, file, ClassUtil.concatName((String)path, (String)fileName));
                continue;
            }
            if (!fileName.endsWith(".class")) continue;
            String className = ClassUtil.concatName((String)path, (String)this.removeExtension(fileName));
            this.loadClass(loader, className);
        }
    }

    protected byte[] transform(ClassTransformer transformer, ClassLoader classLoader, String className, byte[] bytes) {
        byte[] transformed = ClassTransformerUtil.transform(transformer, classLoader, className.replace('.', '/'), null, null, bytes);
        return transformed == null ? bytes : transformed;
    }

    protected ClassLoader getTargetClassLoader(ClassLoader originLoader) {
        ClassLoader loader;
        for (loader = originLoader; loader != null && this.ignoreLoaderClassNames.contains(loader.getClass().getName()); loader = loader.getParent()) {
        }
        if (loader != null) {
            return loader;
        }
        return originLoader;
    }

    protected String removeExtension(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }
}

